/**
 * 판매 메뉴에 관련 Javascript
 */

var OrderMenuService = function () {

	/*********************************************************
	 * 터치상품 분류코드 조회
	 * @parameter langCode 언어코드
	 *********************************************************/
	this.getKioskClsData = function(langCd) {
		let resultData = null;
		
		try {
			resultData = gfn_SQLiteSQLProcess(sqlQuery.getKioskClsData_SQL, [gShopCd]);
			if ( resultData!= null && resultData.ResultCode == "0" ) {

				let rows = resultData.Data;

				if ( rows == undefined || rows == null ||  rows.length == 0 ) {
					util.logError( "KIOSK 의 그룹정보를 가져오지 못하였습니다." );
					return [];
				}
				
				if(!util.isEmpty(gBarodaInfo)) {
					for(var i=0; i < rows.length; i++) {
						if(rows[i].TU_CLS_NM_EN == "MEMBERSHIP" || rows[i].TU_CLS_NM_EN == "구독권") {
							rows.splice(i, 1);
							break;
						}
					}
				}
				return util.setRowsLanguage( rows, langCd, 'TU_CLS_NM'  );//언어처리.

			}
		} catch (e) {
			util.logError(e);
			throw e;
		}

	} //end getKioskClsData
	,

	// 터치키분류 반복적용 설정..
	this.getKioskClsDataRepeatedApplication = function(obj) {

		/*
		'구분자 '|'

			[반복주기 유형(; 첫번째 구분자 앞의 데이터) 코드]
			D:매일 W:매주 M:매월 Y:매년

			['반복주기 유형'별 설명]
			1. 매일(D) - 부가정보 없음
			2. 매주(W) - 첫번째 구분자 다음에는 요일 정보가 세팅됨
			3. 매월(M) - 첫번째 구분자 다음의 데이터는 '요일(YOIL)' 또는 '일(DAY)'을 나타냄
			3.1. 요일(YOIL) - 두번째 구분자 다음에는 요일순번 정보가, 세번째 구분자 다음에는 요일 정보가 세팅됨
			3.2. 일(DAY) - 두번째 구분자 다음에는 DD(일) 정보가 세팅됨
			4. 매년(Y) - 첫번째 구분자 다음에 MMDD(월일) 정보가 세팅됨

			[요일 코드]
			1:일 2:월 3:화 4:수 5:목 6:금 7:토

			[요일순번 코드 목록]
			1:첫째 2:둘째 3:셋째 4:넷째 5:다섯째

			예시)
			① 매일 ☞ 'D'
			② 매주 수요일 ☞ 'W|4'
			③ 매월 셋째 금요일 ☞ 'M|YOIL|3|6'
			④ 매월 05일 ☞ M|DAY|05
			⑤ 매년 05월 05일 ☞ 'Y|0505'
		
		*/

		var resultList = [];

		for(var i=0; i < obj.length; i++){
			let isDisp = true;
			
			const recurTerm = obj[i].RECUR_TERM;

			if('Y' === obj[i].TU_CLS_DISP_FG){
				isDisp = true;
			}else{
				if(gOrderType == "takeout"){
					if('T' === obj[i].TU_CLS_DISP_FG){ // 포장하기만
						isDisp = true;
					}else{
						isDisp = false;
					}
				}else{
					if('N' === obj[i].TU_CLS_DISP_FG){ // 먹고가기만
						isDisp = true;
					}else{
						isDisp = false;
					}
				}
				
			}

			if(isDisp && !util.isEmptyStr(recurTerm)){

				const recurTermArr = recurTerm.split('|');				
				const recurSDate = obj[i].RECUR_S_DATE; // 반복적용시작일
				const recurEDate = obj[i].RECUR_E_DATE; // 반복적용종료일
				const currentDate = moment().format('YYYYMMDD'); // 현재날짜
				const currentDateMD = moment().format('MMDD'); // 현재월일
				const currentDateD = moment().format('DD'); // 현재일자
				const currentWeeks = String(moment().weeks()); // 현재주 순번
				const currentDays = String((moment().days()) + 1); // 현재요일코드

				// 반복적용시작 - 종료일
				if(recurSDate <= currentDate && recurEDate >= currentDate){
					if('D' === recurTermArr[0]){ // 매일 : 부가정보없음..
					}else if('W' === recurTermArr[0]){ // 매주
						if(currentDays !== recurTermArr[1]){ // 요일코드
							isDisp = false;
						}
					}else if('M' === recurTermArr[0]){ // 매월
						if('YOIL' === recurTermArr[1]){
							// recurTermArr[2] // 요일순번
							// recurTermArr[3] // 요일코드
							if(currentWeeks === recurTermArr[2] && currentDays === recurTermArr[3]){
								isDisp = true;
							}else{
								isDisp = false;
							}
						}else if('DAY' === recurTermArr[1]){							
							if(currentDateD === recurTermArr[2]){ // 일자
								isDisp = true;
							}else{
								isDisp = false;
							}
						}
					}else if('Y' === recurTermArr[0]){ // 매년
						if(currentDateMD === recurTermArr[1]){ // 월일
							isDisp = true;
						}else{
							isDisp = false;
						}						
					}

					const recurSTime = obj[i].RECUR_S_TIME; // 반복적용시작시간
					const recurETime = obj[i].RECUR_E_TIME; // 반복적용종료시간
					const currentTime = moment().format('HHmm'); // 현재시간
					
					if(isDisp && !util.isEmptyStr(recurSTime)){
						if(recurSTime <= currentTime && recurETime >= currentTime){
							isDisp = true;
						}else{
							isDisp = false;
						}
					}

				}else{
					isDisp = false;
				}
			}

			if(isDisp){
				resultList.push(obj[i]);
			}

		}

		return resultList;

	},
	
	/*********************************************************
	 * 터치상품 분류코드 조회
	 * @parameter langCode 언어코드
	 *********************************************************/
	this.getKioskClsDataForCornerPay = function(langCd, gProdAllList) {
		let resultData = null;
		
		try {
			
			var tuClsCd = [];
			for(var i=0; i < gProdAllList.length; i++){
				tuClsCd.push(gProdAllList[i].TU_CLS_CD);
			}
		
			
			
			tuClsCd = Array.from(new Set(tuClsCd));
			
			util.logInfo("tuClsCd >>> " + tuClsCd);
			
			var tuClsCdStr = "";
			for(var i=0; i < tuClsCd.length; i++){
				if(i+1 < tuClsCd.length) tuClsCdStr += tuClsCd[i] + "','"
				else tuClsCdStr += tuClsCd[i];
			}
			
			//console.log("tuClsCdStr >>> " + tuClsCdStr);
			
			resultData = gfn_SQLiteSQLProcess(sqlQuery.getKioskClsDataForCornerPay_SQL.sprintf(gShopCd, tuClsCdStr), []);
			if ( resultData!= null && resultData.ResultCode == "0" ) {
				
				let rows = resultData.Data;
				
				if ( rows == undefined || rows == null ||  rows.length == 0 ) {
					util.logError( "KIOSK 의 그룹정보를 가져오지 못하였습니다." );
					return [];
				}
				
				return util.setRowsLanguage( rows, langCd, 'TU_CLS_NM'  );//언어처리.
				
			}
		} catch (e) {
			util.logError(e);
			throw e;
		}
		
	} //end getKioskClsData
	,

	/************************************************
	 * 상품데이터 조회
	 * @parameter clsCd 터치분류코드
	 * @parameter langCode 언어코드
	 ************************************************/
	this.getProductData = function (clsCd, _langCode, vatCd) {
		var resultData;
		// CORNER_PAY_TYPE 타입이 1이면 코너사업자코드별로 메뉴를 보여준다.
		// CORNER_PAY_TYPE 0인경우 모든메뉴
		var cornerPayType = SHOP_INFO.CORNER_PAY_TYPE; 
		var memServiceYn = "0";
		
		if(gMemberServiceYn == "Y") memServiceYn = "1";

		
		
		//특정시간판매 상품만 노출할지 체크
		var specialTimeSale = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdCnt_SQL, [gShopCd]).Data;
		var specialTimeSaleYn = "0";
		
		if(!util.isEmpty(specialTimeSale)) {
			if(specialTimeSale[0].TIME_SALE_CNT > 0) specialTimeSaleYn = "1";
			else specialTimeSaleYn = "0";	
		}
		
		//먹고가기 or 포장하기별로 상품리스트 조회를 구분하기위한 변수 
        if(gvEatTakeOutVal == "0" || gvEatTakeOutVal == "1" || gvEatTakeOutVal == "2") {
        	//포장하기 먹고가기 버튼을 눌렀을경우
        	if(gOrderType == "takeout") {
        		if(cornerPayType == "0") {
        			//TOGO_PROD_YN 포장하기 and 모두 and 빈값 노출 - 먹고가기 노출X
        			resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdToGoData_SQL, ["N" , gShopCd, memServiceYn, specialTimeSaleYn, gShopCd , "N" , vatCd , gShopCd , gShopCd , clsCd , "ALL", gCornerCd, gShopCd , gPosNo, gShopCd ]);
        		} else {
        			resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdToGoData_SQL, ["N" , gShopCd, memServiceYn, specialTimeSaleYn, gShopCd , "N" , vatCd , gShopCd , gShopCd , clsCd , "NO", gCornerCd, gShopCd , gPosNo, gShopCd ]);
        		}
        	} else {
        		if(cornerPayType == "0") {
        			//TOGO_PROD_YN 먹고가기 and 모두 and 빈값 노출 - 포장하기 노출X
            		resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdToGoData_SQL, ["T" , gShopCd, memServiceYn, specialTimeSaleYn, gShopCd , "T" , vatCd , gShopCd , gShopCd , clsCd , "ALL", gCornerCd , gShopCd , gPosNo, gShopCd ]);
        		} else {
        			resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdToGoData_SQL, ["T" , gShopCd , memServiceYn, specialTimeSaleYn, gShopCd , "T" , vatCd , gShopCd , gShopCd , clsCd , "NO", gCornerCd , gShopCd , gPosNo, gShopCd ]);
        		}
        	}
        } else {
        	let barodaSubNm = "정기구독";
        	if(!util.isEmpty(gBarodaInfo)) {
        		if(gBarodaInfo.subscribeProductCode == "E9900001") { //아메리카노 구독권
        			barodaSubNm = "정기구독_아메리카노";
        		} else { //E9900002  전메뉴 구독권
        			barodaSubNm = "정기구독";
        		}
        	} 
        	
			util.logInfo("바로다 멤버십 :  " + memServiceYn);
			util.logInfo("바로다 barodaSubNm :  " + barodaSubNm);

			
        	if(cornerPayType == "0") {
        		//그외 버튼(식사하기, 계산하기 등)
        		resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdData_SQL, [gShopCd, memServiceYn, barodaSubNm, specialTimeSaleYn, gShopCd , vatCd , gShopCd , gShopCd , clsCd , "ALL", gCornerCd , gShopCd , gPosNo, gShopCd ]);// 1 : VAT CD 추후 128
    		} else {
    			resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdData_SQL, [gShopCd, memServiceYn, barodaSubNm, specialTimeSaleYn, gShopCd , vatCd , gShopCd , gShopCd , clsCd , "NO", gCornerCd , gShopCd , gPosNo, gShopCd ]);// 1 : VAT CD 추후 128
    		}
        	
        }
        
		if ( resultData!= null && resultData.ResultCode == "0" ) {
			let rows = resultData.Data;
			delete resultData.Data;
			if ( rows == undefined || rows == null ||  rows.length == 0 ) {
				return [];
			}
			var rowCnt = rows.length;
			for ( let i = 0 ; i < rowCnt ; i++ ) {
				let row = rows[i];
				let saleUrpc = Number(row.SALE_UPRC);

				if(kerbanDiscountRateYn == 'Y'){ // 커반 할인률 적용
					//if(kerbanDiscountRateYn == 'Y' && row.STAMP_USE_YN == 'Y'){ // 커반 할인률 적용
					saleUrpc = saleUrpc - (Math.round(saleUrpc * (kerbanDiscountRate / 100)));
				}

				row['판매단가']		= saleUrpc; //판매가격 숫자로 변환
				//row['판매단가_출력용']	= util.numberWithCommas(row.SALE_UPRC); //판매가격 Text 로 보여질 값.
				row['판매단가_출력용']	= util.numberWithCommas(saleUrpc); //판매가격 Text 로 보여질 값.
				row['합계금액']		= saleUrpc  ; //합계금액으로 계산하기 위하여.
				row['합계금액_출력용']	= row.SALE_UPRC_VIEW; //합계금액을 산출 후 보여줄 Text(사용은 됨)
				
				if(row.DESCRIPTION != null) {
					row.DESCRIPTION = row.DESCRIPTION.replace(/&amp;/gim, "&");
					row.DESCRIPTION = row.DESCRIPTION.replace(/&lt;/gim, "<");
					row.DESCRIPTION = row.DESCRIPTION.replace(/&gt;/gim, ">");
					row.DESCRIPTION = row.DESCRIPTION.replace(/&nbsp;/gim, " ");
					row.DESCRIPTION = row.DESCRIPTION.replace(/&quot;/gim, '"');
				}
				
				if(row.DESCRIPTION_EN != null) {
					row.DESCRIPTION_EN = row.DESCRIPTION_EN.replace(/&amp;/gim, "&");
					row.DESCRIPTION_EN = row.DESCRIPTION_EN.replace(/&lt;/gim, "<");
					row.DESCRIPTION_EN = row.DESCRIPTION_EN.replace(/&gt;/gim, ">");
					row.DESCRIPTION_EN = row.DESCRIPTION_EN.replace(/&nbsp;/gim, " ");
					row.DESCRIPTION_EN = row.DESCRIPTION_EN.replace(/&quot;/gim, '"');
				}
			
				////// 베스트 화면에 상품설명을 한줄만 간단하게 보이도록 커스터 마이징 처리. ///////
				var vsDesc = row.DESCRIPTION;
				var vsDescEn = row.DESCRIPTION_EN;
				if(!!vsDesc) {
					var idx = vsDesc.indexOf("<br");
					if(idx > -1) { // br 태그가 존재하는 경우 첫번째 줄까지만 자르고, 태그를 제거한다.
						vsDesc = vsDesc.substring(0, idx);
						vsDesc = vsDesc.replace(/(<([^>]+)>)/ig,"");
					} else { // br 태그가 존재하지 않는 경우 한줄이기 때문에 바로 태그만 없애도록 한다.
						vsDesc = vsDesc.replace(/(<([^>]+)>)/ig,"");
					}
				}				
				row.DESCRIPTION_S = vsDesc;
				
				if(!!vsDescEn) {
					var idxEn = vsDescEn.indexOf("<br");
					if(idxEn > -1) { // br 태그가 존재하는 경우 첫번째 줄까지만 자르고, 태그를 제거한다.
						vsDescEn = vsDescEn.substring(0, idxEn);
						vsDescEn = vsDescEn.replace(/(<([^>]+)>)/ig,"");
					} else { // br 태그가 존재하지 않는 경우 한줄이기 때문에 바로 태그만 없애도록 한다.
						vsDescEn = vsDescEn.replace(/(<([^>]+)>)/ig,"");
					}
				}				
				row.DESCRIPTION_S_EN = vsDescEn;
				////// 베스트 화면에 상품설명을 한줄만 간단하게 보이도록 커스터 마이징 처리. 끝. /////////

				//이미지 URL Check
				
				
			}
			
			//단독사업자일떄는 강제적으로 CORNER_CD를 00으로 통일 -> 사업자를 단독&복수로 임의대로 바꿔서 CHG_BILL_NO의 채번이 정상적으로 작동안함
			if(BIZ_CLS_TYPE == '0') {
				rows.forEach(e=>{
					if( !util.isEmpty( e.CORNER_CD ) ) e.CORNER_CD = "00"; 
				});
			}
			
			//debugger;
			if ( _langCode == 'org') {
				rows.forEach(e=>{
					if( !util.isEmpty( e.PRT_NO ) )
						e.printNos = e.PRT_NO.split(",");
					else {
						e.printNos = [];
						e.PRT_NO ="";
					}
				});
				return rows;
			}

			util.setRowsLanguage( rows, _langCode, 'DESCRIPTION'  );//언어처리.
			util.setRowsLanguage( rows, _langCode, 'DESCRIPTION_S'  );//언어처리.
			return  util.setRowsLanguage( rows, _langCode, 'PROD_NM'  );//언어처리.
		}
		return [];
	}
	/************************************************
	 * 상품데이터 조회 바코드용
	 * @parameter clsCd 터치분류코드
	 * @parameter langCode 언어코드
	 ************************************************/
	this.getProductDataForBarcode = function (clsCd, _langCode, vatCd) {
		var resultData;
		// CORNER_PAY_TYPE 타입이 1이면 코너사업자코드별로 메뉴를 보여준다.
		// CORNER_PAY_TYPE 0인경우 모든메뉴
		var cornerPayType = SHOP_INFO.CORNER_PAY_TYPE; 
		var memServiceYn = "0";
		
		if(gMemberServiceYn == "Y") memServiceYn = "1";
		
		//특정시간판매 상품만 노출할지 체크
		var specialTimeSale = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdCnt_SQL, [gShopCd]).Data;
		var specialTimeSaleYn = "0";
		
		if(!util.isEmpty(specialTimeSale)) {
			if(specialTimeSale[0].TIME_SALE_CNT > 0) specialTimeSaleYn = "1";
			else specialTimeSaleYn = "0";	
		}
		
		//먹고가기 or 포장하기별로 상품리스트 조회를 구분하기위한 변수 
		if(gvEatTakeOutVal == "0" || gvEatTakeOutVal == "1" || gvEatTakeOutVal == "2"){
			//포장하기 먹고가기 버튼을 눌렀을경우
			if(gOrderType == "takeout"){
				if(cornerPayType == "0"){
					//TOGO_PROD_YN 포장하기 and 모두 and 빈값 노출 - 먹고가기 노출X
					resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdToGoForBarcodeData_SQL, ["N" , gShopCd, memServiceYn, specialTimeSaleYn, gShopCd , "N" , vatCd , gShopCd , gShopCd , "ALL", gCornerCd, gShopCd , gPosNo, gShopCd ]);
				} else {
					resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdToGoForBarcodeData_SQL, ["N" , gShopCd, memServiceYn, specialTimeSaleYn, gShopCd , "N" , vatCd , gShopCd , gShopCd , "NO", gCornerCd, gShopCd , gPosNo, gShopCd ]);
				}
			} else {
				if(cornerPayType == "0"){
					//TOGO_PROD_YN 먹고가기 and 모두 and 빈값 노출 - 포장하기 노출X
					resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdToGoForBarcodeData_SQL, ["T" , gShopCd, memServiceYn, specialTimeSaleYn, gShopCd , "T" , vatCd , gShopCd , gShopCd , "ALL", gCornerCd , gShopCd , gPosNo, gShopCd ]);
				} else {
					resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdToGoForBarcodeData_SQL, ["T" , gShopCd, memServiceYn, specialTimeSaleYn, gShopCd , "T" , vatCd , gShopCd , gShopCd , "NO", gCornerCd , gShopCd , gPosNo, gShopCd ]);
				}
			}
		} else {
			
			if(cornerPayType == "0"){
				//그외 버튼(식사하기, 계산하기 등)
				resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdForBarcodeData_SQL, [gShopCd, memServiceYn, specialTimeSaleYn, gShopCd , vatCd , gShopCd , gShopCd , "ALL", gCornerCd , gShopCd , gPosNo, gShopCd ]);// 1 : VAT CD 추후 128
			} else {
				resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdProducdForBarcodeData_SQL, [gShopCd, memServiceYn, specialTimeSaleYn, gShopCd , vatCd , gShopCd , gShopCd , "NO", gCornerCd , gShopCd , gPosNo, gShopCd ]);// 1 : VAT CD 추후 128
			}
			
		}
		if ( resultData!= null && resultData.ResultCode == "0" ) {
			let rows = resultData.Data;
			delete resultData.Data;
			if ( rows == undefined || rows == null ||  rows.length == 0 ) {
				return [];
			}
			var rowCnt = rows.length;
			for ( let i = 0 ; i < rowCnt ; i++ ) {
				let row = rows[i];
				let saleUrpc = Number(row.SALE_UPRC);

				if(kerbanDiscountRateYn == 'Y'){ // 커반 할인률 적용
					//if(kerbanDiscountRateYn == 'Y' && row.STAMP_USE_YN == 'Y'){ // 커반 할인률 적용
					saleUrpc = saleUrpc - (Math.round(saleUrpc * (kerbanDiscountRate / 100)));
			   	}

				row['판매단가']		     = saleUrpc;//판매가격 숫자로 변환
				//row['판매단가_출력용']	= util.numberWithCommas(row.SALE_UPRC);//판매가격 Text 로 보여질 값.
				row['판매단가_출력용']	= util.numberWithCommas(saleUrpc);//판매가격 Text 로 보여질 값.
				row['합계금액']			= saleUrpc  ;//합계금액으로 계산하기 위하여.
				row['합계금액_출력용']	= row.SALE_UPRC_VIEW;//합계금액을 산출 후 보여줄 Text(사용은 됨)
				
				if(row.DESCRIPTION != null){
					row.DESCRIPTION = row.DESCRIPTION.replace(/&amp;/gim, "&");
					row.DESCRIPTION = row.DESCRIPTION.replace(/&lt;/gim, "<");
					row.DESCRIPTION = row.DESCRIPTION.replace(/&gt;/gim, ">");
					row.DESCRIPTION = row.DESCRIPTION.replace(/&nbsp;/gim, " ");
					row.DESCRIPTION = row.DESCRIPTION.replace(/&quot;/gim, '"');
				}
				
				if(row.DESCRIPTION_EN != null){
					row.DESCRIPTION_EN = row.DESCRIPTION_EN.replace(/&amp;/gim, "&");
					row.DESCRIPTION_EN = row.DESCRIPTION_EN.replace(/&lt;/gim, "<");
					row.DESCRIPTION_EN = row.DESCRIPTION_EN.replace(/&gt;/gim, ">");
					row.DESCRIPTION_EN = row.DESCRIPTION_EN.replace(/&nbsp;/gim, " ");
					row.DESCRIPTION_EN = row.DESCRIPTION_EN.replace(/&quot;/gim, '"');
				}
				
				////// 베스트 화면에 상품설명을 한줄만 간단하게 보이도록 커스터 마이징 처리. ///////
				var vsDesc = row.DESCRIPTION;
				var vsDescEn = row.DESCRIPTION_EN;
				if(!!vsDesc){
					var idx = vsDesc.indexOf("<br");
					if(idx > -1){ // br 태그가 존재하는 경우 첫번째 줄까지만 자르고, 태그를 제거한다.
						vsDesc = vsDesc.substring(0, idx);
						vsDesc = vsDesc.replace(/(<([^>]+)>)/ig,"");
					}else{ // br 태그가 존재하지 않는 경우 한줄이기 때문에 바로 태그만 없애도록 한다.
						vsDesc = vsDesc.replace(/(<([^>]+)>)/ig,"");
					}
				}				
				row.DESCRIPTION_S = vsDesc;
				
				if(!!vsDescEn){
					var idxEn = vsDescEn.indexOf("<br");
					if(idxEn > -1){ // br 태그가 존재하는 경우 첫번째 줄까지만 자르고, 태그를 제거한다.
						vsDescEn = vsDescEn.substring(0, idxEn);
						vsDescEn = vsDescEn.replace(/(<([^>]+)>)/ig,"");
					}else{ // br 태그가 존재하지 않는 경우 한줄이기 때문에 바로 태그만 없애도록 한다.
						vsDescEn = vsDescEn.replace(/(<([^>]+)>)/ig,"");
					}
				}				
				row.DESCRIPTION_S_EN = vsDescEn;
				////// 베스트 화면에 상품설명을 한줄만 간단하게 보이도록 커스터 마이징 처리. 끝. /////////
				
			}
			
			//단독사업자일떄는 강제적으로 CORNER_CD를 00으로 통일 -> 사업자를 단독&복수로 임의대로 바꿔서 CHG_BILL_NO의 채번이 정상적으로 작동안함
			if(BIZ_CLS_TYPE == '0') {
				rows.forEach(e=>{
					if( !util.isEmpty( e.CORNER_CD ) ) e.CORNER_CD = "00"; 
				});
			}
			
			//debugger;
			if ( _langCode == 'org') {
				rows.forEach(e=>{
					if( !util.isEmpty( e.PRT_NO ) )
						e.printNos = e.PRT_NO.split(",");
					else {
						e.printNos = [];
						e.PRT_NO ="";
					}
				});
				return rows;
			}
			
			util.setRowsLanguage( rows, _langCode, 'DESCRIPTION'  );//언어처리.
			util.setRowsLanguage( rows, _langCode, 'DESCRIPTION_S'  );//언어처리.
			return  util.setRowsLanguage( rows, _langCode, 'PROD_NM'  );//언어처리.
		}
		return [];
	}

	this.getSideMenuGroupList = function ( row , _langCode ) {

		let resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdSideMenuGroup_SQL , [gShopCd , row.SDA_CLS_CD , gShopCd , row.SDS_GRP_CD ]) ;//TODO 실제 값으로 변경.
		if ( resultData !=  null && resultData.ResultCode == '0' ) {
			let rows =resultData.Data;
			if ( rows == null || rows.length == 0  ) {
				return [];
			}
			rows = util.setRowsLanguage( rows, _langCode, 'SIDE_NM'  );
			return rows;
		}
		return [];
	}

	this.getSideMenuDetailList = function (row , _langCode) {
		//상품처리 상품에서 tax 구분..코드 허용..  VAT_CD
		let vatCd = util.GetEnvXmlShopENV(128);
		let resultData = gfn_SQLiteSQLProcess(sqlQuery.menuProdSideMenuDetail_SQL , [gShopCd , row.SDA_CLS_CD , gShopCd , gShopCd , gShopCd , gShopCd , row.SDS_GRP_CD  ,  vatCd ]) ;//VAT CD 128
		util.logInfo("side param ", JSON.stringify(row));

		if ( resultData !=  null && resultData.ResultCode == '0' ) {
			let rows =resultData.Data;
			if ( rows == undefined || rows == null || rows.length == 0  ) {
				return [];
			}

			rows = util.setRowsLanguage( rows, _langCode, 'SIDE_NM'  );
			rows.forEach(e => {
				e['TXT'] = JSON.stringify(e);//주문정보 입력시 필요함.
			});
			return rows;
		}
		return [];
	}

	this.notiMessageComponent = function () {
		let template = {
				  template : "#messagePopup"
				, data : function() {
					let obj = {
					      styleObject : {display : 'none'}
						, message : ""
						, messageType : ""
					}
					obj.lang_notice_title         = util.languageObjReturn(langCode, 'noticeTitle');
					obj.lang_notice_cancel        = util.languageObjReturn(langCode, 'noticeCancel');
					obj.lang_notice_confirm       = util.languageObjReturn(langCode, 'noticeConfirm');
					return obj;
				}

				, created : function () {
					util.logInfo('noti message create');
				}
				,
				 beforeDestroy () {
					this.$root.$off( 'notiMessage' );
				}
				, mounted : function () {
					this.$root.$on("notiMessage" , obj => {
						this.message = obj.message;
						this.messageType = obj.messageType;
						this.styleObject = {display :'block'};
					});
				}

				, methods : {
					fn_self_popup_close : function() {
						this.styleObject = {display : 'none'};
					}
					,
					fn_message_btn : function (flag) {
						this.$root.$emit("notiChoiceResult" , flag );
						this.styleObject = {display : 'none'};
					}
					,
				}

				, updated : function () {
					util.logInfo('notiMessageComponent  updated');
				}
				, beforeUpdate : function(){
		            util.logInfo('notiMessageComponent  beforeUpdate');
		        }

		};///end let template
		return template;
	}

	this.orderSideComponent = function () {
		let swpList  = [];//사이드 내부 속성 및 선택들.
		let swiperOption ; //레이어 내부 슬라이드 시작
		let template = {
				  template : "#prodSideTemplate"
				, data : function() {
					return {
					    sideGrpList     : []  /** SIDE 그룹정보   **/
					  , sideList        : []  /** SIDE LIST 정보  **/
					  , prodInfo        : []  /** 사이드 상품정보 **/
					  , styleObject     : {display : 'none'}
					  , styleNosideList : {display : 'block'}
					  , currentData     : ""
					  , langContaining  : util.languageObjReturn(langCode, 'containing')
					  , selectSideFg    : []
					  , selectBoxType	: "radio"
					  , sidePopDiv	    : ""
					  , vsLangCode      : langCode
					  , sideQtyYn       : gsSideQtyYn
					}
				}
				, created : function () {
					util.logInfo('side Layer created');
				}
				,
				 beforeDestroy () {
					this.$root.$off('sideMenuList' );
					swiperOption = undefined;
					if( swpList.length != 0   ) {
						swpList.forEach(swp =>{
							swp = null;
						});
					}
					swpList = [];
				}
				, mounted : function () {
					this.$root.$on("sideMenuList" , obj => {
						//util.logDebug("side Menu List Recieve : " + JSON.stringify (obj ) );
						util.logInfo("side Menu List Recieve : " + JSON.stringify (obj ) );
						this.styleObject = {display : 'block'};
						this.styleNosideList = {display : 'block'};
						this.prodInfo    = obj.prodInfo;
						this.sideGrpList = obj.sideGrpList;
						this.sideList    = obj.sideList;
						this.currentData = getCurrentDate();
						
						if(typeof(swiperOption) !== "undefined"){
							swiperOption.destroy(true, true);
							swiperOption = undefined;
						}
						
						
//						obj.menuDiv = '2';
						//this.sideGrpList = null
						// 한국어인 경우에 한글상품설명이 없거나, 영어일 때 영어상품설명이 없거나, 사이드화면 환경변수가 빈값인 경우 또는 0인 경우, 해당 사이드상품의 설명 사용여부가 Y가 아닌경우 기본사이드화면으로 구동.
						if( (!this.prodInfo.DESCRIPTION && langCode=="ko" && obj.menuDiv != "2") || (!this.prodInfo.DESCRIPTION_EN && langCode=="en"  && obj.menuDiv != "2") || obj.menuDiv == "0" || !obj.menuDiv || this.prodInfo.DESCRIPTION_DISP_YN != "Y"){							
							this.sidePopDiv = "0"; // 사이드 팝업 종류 기본으로 설정. (위의 if문 조건에 하나라도 해당되면 기본화면으로)
							$("#sideOptionLayer").attr("class", "layerPopup");
							$("#sideLayerDesc").attr("class", "layerContent menu_option"); // 사이드메뉴 리스트가 있는 경우 원래 리스트가 보이는 class로 변경
							$("#sideDetailOption").attr("class", "menu_detail_option_list_type2"); // 사이드메뉴 설명 테두리가 뾰족,라운드로 각각 달라서 나중에 동일하도록 추가된 class
							swiperOption = new Swiper('.optionListWrap', {
								direction: 'vertical',
								slidesPerView: 'auto', // 24-02-26 수정
								//slidesPerGroup :1,
								navigation: {
									nextEl: '.option_down',
									prevEl: '.option_up',
								},
							});
							
						}else{
							
							this.sidePopDiv = obj.menuDiv; // 사이드 팝업 종류 셋팅.(파라미터로 넘어온)
							// 상품설명 치환 시작
							this.prodInfo.DESCRIPTION = this.prodInfo.DESCRIPTION.replace(/&amp;/gim, "&");
							this.prodInfo.DESCRIPTION = this.prodInfo.DESCRIPTION.replace(/&lt;/gim, "<");
							this.prodInfo.DESCRIPTION = this.prodInfo.DESCRIPTION.replace(/&gt;/gim, ">");
							this.prodInfo.DESCRIPTION = this.prodInfo.DESCRIPTION.replace(/&nbsp;/gim, " ");
							this.prodInfo.DESCRIPTION = this.prodInfo.DESCRIPTION.replace(/&quot;/gim, '"');
							// 사이드메뉴 리스트가 없는 경우에 해당 상품 설명 화면이 나오도록 처리.
							if(this.sideGrpList == null || this.sideGrpList == undefined || this.sideGrpList == "" || this.sideGrpList.length == 0){
								// 사이드 메뉴 나오지 않고 상품설명만 나오는 class 적용.
								$("#sideOptionLayer").attr("class", "layerPopup select_menu_double_line_popup");
								$("#sideLayerDesc").attr("class", "layerContent menu_option option_list_disable"); // 사이드메뉴 리스트가 없는 경우 리스트가 안보이는 class로 변경
								$("#sideDetailOption").attr("class", "menu_detail_option_list_type1"); // 사이드메뉴 설명 테두리가 뾰족,라운드로 각각 달라서 나중에 동일하도록 추가된 class
								this.styleNosideList = {display : 'none'};
								setTimeout(this.fnDescripSet, 100);
							}else{ // 상품이 있는 경우에 환경변수에 따른 사이드화면이 나오도록 설정.
								if(this.sidePopDiv == "1"){ // 상품설명만 적용된 화면
									$("#sideOptionLayer").attr("class", "layerPopup select_menu_double_line_popup");
									$("#sideLayerDesc").attr("class", "layerContent menu_option"); // 사이드메뉴 리스트가 있는 경우 원래 리스트가 보이는 class로 변경
									$("#sideDetailOption").attr("class", "menu_detail_option_list_type1"); // 사이드메뉴 설명 테두리가 뾰족,라운드로 각각 달라서 나중에 동일하도록 추가된 class
									swiperOption = new Swiper('.optionListWrap', {
										direction: 'vertical',
										slidesPerView: 'auto',
										slidesPerGroup :1,
										navigation: {
											nextEl: '.option_down',
											prevEl: '.option_up',
										},
									});
									
									setTimeout(this.fnDescripSet, 100);
								}else if(this.sidePopDiv == "2"){ // 상품설명과 사이드 이미지 적용된 화면
									$("#sideOptionLayer").attr("class", "layerPopup select_menu_double_line_popup2");
									$("#sideLayerDesc").attr("class", "layerContent menu_option"); // 사이드메뉴 리스트가 있는 경우 원래 리스트가 보이는 class로 변경
									$("#sideDetailOption").attr("class", "menu_detail_option_list_type2"); // 사이드메뉴 설명 테두리가 뾰족,라운드로 각각 달라서 나중에 동일하도록 추가된 class, 사이드 이미지로 나오는 경우에 사이드 맨 왼쪽에 분류 표시되도록 추가됨.
									// 상품설명과 사이드 이미지 적용된 화면일 때 세로 swiper의 slidesPerView를 2로 설정.
									swiperOption = new Swiper('.optionListWrap', {
										direction: 'vertical',
										slidesPerView: 'auto',
										slidesPerGroup :1,
										navigation: {
											nextEl: '.option_down',
											prevEl: '.option_up',
										},
									});
									setTimeout(this.fnDescripSet, 100);
									
								}
							}
						}
						util.logInfo("*****prodSideTemplate mount this.sidePopDiv == > " + this.sidePopDiv);
						util.logInfo("*****prodSideTemplate mount this.prodInfo.PROD_NM == > " + this.prodInfo.PROD_NM);
						util.logInfo("*****prodSideTemplate mount this.prodInfo.DESCRIPTION_DISP_YN == > " + this.prodInfo.DESCRIPTION_DISP_YN);
						util.logInfo("*****prodSideTemplate mount this.prodInfo.DESCRIPTION == > " + this.prodInfo.DESCRIPTION);
						util.logInfo("*****prodSideTemplate mount this.prodInfo.DESCRIPTION_EN == > " + this.prodInfo.DESCRIPTION_EN);
					});
								
					//사이드메뉴 선택 옵션 
					//0 : 단일 선택 ( 기본값) , 1 : 멀티선택, 2: 단일선택 필수 , 3 : 멀티선택 필수
					if(SHOP_INFO.SIDE_SEL_OPTION == "1" || SHOP_INFO.SIDE_SEL_OPTION == "3"){
						this.selectBoxType = "checkbox";
					}
				}

				, methods : {
					fnDescripSet : function(){
						if(langCode=="en"){
							$("#sideDescEn").html(this.prodInfo.DESCRIPTION_EN);
						}else{									
							$("#sideDesc").html(this.prodInfo.DESCRIPTION);
						}
					}
					, fn_self_popup_close : function() {
						this.prodInfo    = [];
						this.sideGrpList = [];
						this.sideList    = [];
						this.selectSideFg = [];
						//기존 데이터 초기화함.
						swpList = [] ;
						$("#noti_message").html("");
						this.styleObject = {display : 'none'};
					}
					, fnToggle : function(obj, paSdsProcFg, paSideType) {
						let objId = obj.target.id;
						let sideIdx = objId.substring(6);
						sideIdx = sideIdx.replace("_","");
						let objNm = obj.target.name;
						let val;
						let vsType = obj.target.type; // radio인지 checkBox인지 판단하여 단일/멀티를 구분한다.
						//console.log( 'name : ' + obj.target.name , 'id : ' + obj.target.id ,  $("input[id='" +objId+ "']").prop("checked" ));
//						if(SHOP_INFO.SIDE_SEL_OPTION == "1" || SHOP_INFO.SIDE_SEL_OPTION == "3") {
						if(vsType == "checkbox") { // 멀티선택일 때
							//체크박스
							val = $("#H" +objId ).val();
							//한번더 클릭하면 초기화 처리.
							if ( objId == val ) {
								$("input[id='" +objId+ "']").prop("checked", false);
								$("#H" +objId ).val("");
								$("#outcome_"+sideIdx).val("0"); // 사이드 수량을 0으로 초기화한다.
								// 속성은 이전의 옵션(SHOP_INFO.SIDE_SEL_OPTION)을 그대로 사용하고, 선택 옵션만 그룹테이블의 SDS_PROC_FG 컬럼의 값을 사용하도록 개선되어 속성과 선택에 대한 조건을 수정처리
								if((paSideType == "A" && SHOP_INFO.SIDE_SEL_OPTION == "3") || (paSideType == "B" && paSdsProcFg == "3")) {
								// if(SHOP_INFO.SIDE_SEL_OPTION == "3"){
									let sideCheckLen = $("input:checkbox[name='"+objNm+"']:checked").length;
									if(sideCheckLen == 0) {
										let optStr = obj.target._value.split("＠");
										const idx = this.selectSideFg.indexOf(optStr[2]);
										if (idx > -1) this.selectSideFg.splice(idx, 1);
									}
								} 
							} else {
								
								let optStr = obj.target._value.split("＠");
								
								//품절된 상품은 선택못하도록 
								if(optStr[11] != undefined && optStr[11] == "4") {
									var obj = { message : "", messageType : "alert" };
									
									var message = util.languageObjReturn(langCode,  'itemOutOfStock');
									this.$root.$emit( "notiMessage" ,   obj  );
					    			$('#noti_message').html("<p>"+message+"</p>");
					    			$("input[id='" +objId+ "']").prop("checked", false);
									return;
								} else {
									//아니면 값 설정.
									$("#H" +objId ).val(objId);
									$("#outcome_"+sideIdx).val("1"); // 최초 선택되면 사이드 수량을 1으로 셋팅한다.
								}
							
								// 속성은 이전의 옵션(SHOP_INFO.SIDE_SEL_OPTION)을 그대로 사용하고, 선택 옵션만 그룹테이블의 SDS_PROC_FG 컬럼의 값을 사용하도록 개선되어 속성과 선택에 대한 조건을 수정처리
								if((paSideType == "A" && SHOP_INFO.SIDE_SEL_OPTION == "3") || (paSideType == "B" && paSdsProcFg == "3")) {
								// if(SHOP_INFO.SIDE_SEL_OPTION == "3"){
									//중분류 속성별 선택 저장
									const idx = this.selectSideFg.indexOf(optStr[2]); 
									if (idx < 0) this.selectSideFg.push(optStr[2]);
									
									//this.selectSideFg.push(optStr[2]);
									//배열 중복값제거
									//this.uniqueSelectSideFg = Array.from(new Set(this.selectSideFg));
								}
							}
						} else {
							//라디오버튼
							val = $("#H" +objNm ).val();
							let sideIdxBefore = val.substring(6);
							sideIdxBefore = sideIdxBefore.replace("_","");
							//한번더 클릭하면 초기화 처리.
							if ( objId == val ) {
								$("input[id='" +objId+ "']").prop("checked", false);
								$("#H" +objNm ).val("");
								$("#outcome_"+sideIdx).val("0"); // 사이드 수량을 0으로 초기화한다.
								if((paSideType == "A" && SHOP_INFO.SIDE_SEL_OPTION == "2") || (paSideType == "B" && paSdsProcFg == "2")) {
								//if(SHOP_INFO.SIDE_SEL_OPTION == "2"){
									//중분류 속성별 선택 저장
									let optStr = obj.target._value.split("＠");
									const idx = this.selectSideFg.indexOf(optStr[2]);
									if (idx > -1) this.selectSideFg.splice(idx, 1);
								} 
							} else {
								
								let optStr = obj.target._value.split("＠");
								
								//품절된 상품은 선택못하도록 
								if(optStr[11] != undefined && optStr[11] == "4") {
									var obj = { message : "", messageType : "alert" };
									
									var message = util.languageObjReturn(langCode,  'itemOutOfStock');
									this.$root.$emit( "notiMessage" ,   obj  );
					    			$('#noti_message').html("<p>"+message+"</p>");
					    			$("input[id='" +objId+ "']").prop("checked", false);
									return;
								} else {
									//아니면 값 설정.
									$("#H" +objNm ).val(objId);
									$("#outcome_"+sideIdx).val("1"); // 최초 선택되면 사이드 수량을 1으로 셋팅한다.
									$("#outcome_"+sideIdxBefore).val("0"); // 최초 선택되면 사이드 수량을 1으로 셋팅한다.
								}
								
								
								// 속성은 이전의 옵션(SHOP_INFO.SIDE_SEL_OPTION)을 그대로 사용하고, 선택 옵션만 그룹테이블의 SDS_PROC_FG 컬럼의 값을 사용하도록 개선되어 속성과 선택에 대한 조건을 수정처리
								if((paSideType == "A" && SHOP_INFO.SIDE_SEL_OPTION == "2") || (paSideType == "B" && paSdsProcFg == "2")) {
								//if(SHOP_INFO.SIDE_SEL_OPTION == "2"){
									//중분류 속성별 선택 저장
									const idx = this.selectSideFg.indexOf(optStr[2]); 
									if (idx < 0) this.selectSideFg.push(optStr[2]);
								}
							}
						}
						
						//console.log( 'name : ' + obj.target.name , 'id : ' + obj.target.id ,  $("input[id='" +objId+ "']").prop("checked" ));
						
					}
					,
					fn_side_selected_click : function () { // 담기버튼 클릭
						let rtnObj = [];
						// 0 : 단일 선택 ( 기본값) , 1 : 멀티선택, 2: 단일선택 필수 , 3 : 멀티선택 필수
//						if(SHOP_INFO.SIDE_SEL_OPTION == "2" || SHOP_INFO.SIDE_SEL_OPTION == "3") {
							if(this.selectSideFg.length != this.sideGrpList.length) {
								for(var i = 0; i < this.sideGrpList.length; i++ ) {
									if((this.sideGrpList[i].SIDE_TYPE == "A" && (SHOP_INFO.SIDE_SEL_OPTION == "2" || SHOP_INFO.SIDE_SEL_OPTION == "3")) || (this.sideGrpList[i].SIDE_TYPE == "B" && (this.sideGrpList[i].SDS_PROC_FG == "2" || this.sideGrpList[i].SDS_PROC_FG == "3"))){  
										var sideSelFlag = false;
										for(var j = 0; j < this.selectSideFg.length; j++ ) {
											if(this.sideGrpList[i].SIDE_FG == this.selectSideFg[j]){
												sideSelFlag = true;
											} 
										}
										
										if(!sideSelFlag) {
											//사이드 속성값은 있는데 선택할수있는 사이드메뉴가없는경우 패스하도록
											//사이드 속성값은 있는데 선택할수있는 사이드메뉴가 SOLD OUT인경우에도 패스
											var tempSideList = this.sideList.filter(p => p.SIDE_CLS_CD == this.sideGrpList[i].SIDE_FG );
											
											
											if(tempSideList.length < 1) {
												//선택할 사이드 리스트가없는경우
												sideSelFlag = true;
											} else {
												//선택할 사이드 리스트가 있지만 sold out인 상태
												var soldOutProdCnt = 0;
												for(var x = 0; x < tempSideList.length; x++){
													if(tempSideList[x].KIOSK_PROD_STATUS == "4"){
														soldOutProdCnt++;
													}
												}
												
												if(soldOutProdCnt == tempSideList.length){
													sideSelFlag = true;
												}
											}
											
										}
										
										if(!sideSelFlag) { // 행의 모든 제품이 SOLDOUT이거나 행의 사이드상품이 없는 경우를 제외하고는 필수 선택하라는 알림 보여준다.
											var obj = { message : "", messageType : "alert" };
											var sideNm = "";
											
											if(langCode  == "ko") sideNm = this.sideGrpList[i].SIDE_NM;
											else sideNm = this.sideGrpList[i].SIDE_NM_EN;	
											
											var message1 = sideNm + util.languageObjReturn(langCode,  'notSelected');
											var message2 = util.languageObjReturn(langCode,  'pleaseSelectMenu');
											//obj.message = message1;			
											this.$root.$emit( "notiMessage" ,   obj  );
											//this.makeMessageAlert(obj);
							    			$('#noti_message').html("<p>"+message1+"</p><p>"+message2+"</p>");
											return;
										}
									}
								}
							} 
//						}
							
						$('#sideOptionLayer input[type=radio]:checked , #sideOptionLayer input[type=checkbox]:checked').each(function(idx, itm) {
							  //console.log($(this).val());
							var vsVal = "";							
							if(gsSideQtyYn == "1"){ // 사이드 수량 사용일 때
								var vnSideCnt = $(this).parent().children(".quantity_check").children(".outcome").val();
								if(!vnSideCnt){
									vnSideCnt = 0;
								}
								vsVal = $(this).val() + "＠" + vnSideCnt; // 사이드를 @뒤에 붙여서 메인메뉴선택 화면으로 내려준다.
							}else{ // 사이드 수량 사용이 아닐 때 
								vsVal = $(this).val() + "＠" + 1;
							}
							
							vsVal = vsVal + "＠" + $(this)[0].type; // 선택한 사이드가 checkbox인지 radio인지 마지막 값에 추가로 담는다. (멀티, 단일 인지 추후에 구분하기 위해)
							
							
							rtnObj.push( vsVal );//옵션 선택된 항목 모으기.
						});

						let data = {
								  prodInfo : this.prodInfo
								, optList : rtnObj
						};

						this.$root.$emit("sideMenuResult" , data );

						//할당된 변수 초기화와 layer 초기화 처리.
						this.fn_self_popup_close();
					}

					,
					applySideCssStyle : function() {
						if ( swiperOption != undefined ){
							swiperOption.update();
						}
						if ( this.sideList.length !== 0  && swpList.length == 0 ) {
							if(typeof(swiperOption2) !== "undefined"){
								swiperOption2.destroy(true, true);
								swiperOption2 = undefined;
							}
							
							// 기본 사이드 화면
							if(this.sidePopDiv == "0"){	
								// 기본 사이드 화면일 때 swiper slidesPerView 4로 설정
								$('.optionList .button_wrap').each(function(){
									let target = $(this),
									prev = $(this).find('.option_prev'),
									next = $(this).find('.option_next');

									let swiperOption2 = new Swiper(target, {
										slidesPerView: 4,
										navigation: {
											nextEl: next ,
											prevEl: prev ,
										},
									});
									swpList.push( swiperOption2);
								});

							// 상품설명 추가된 사이드 화면
							}else if(this.sidePopDiv == "1"){ // 상품설명만 추가된 화면
								$('.optionList .button_wrap').each(function(){
									let target = $(this),
									prev = $(this).find('.option_prev'),
									next = $(this).find('.option_next');
									// 상품설명만 추가된 화면일 때 swiper slidesPerView 4로 설정
									let swiperOption2 = new Swiper(target, {
										slidesPerView: 3,
										navigation: {
											nextEl: next ,
											prevEl: prev ,
										},
									});
									swpList.push( swiperOption2);
								});
							}else if(this.sidePopDiv == "2"){ // 상품설명, 이미지 적용된 사이드화면
								$('.optionList .button_wrap').each(function(){
									let target = $(this),
									prev = $(this).find('.option_prev'),
									next = $(this).find('.option_next');
									// 상품설명만 추가된 화면일 때 swiper slidesPerView 3로 설정
									let swiperOption2 = new Swiper(target, {
										slidesPerView: 3,
										navigation: {
											nextEl: next ,
											prevEl: prev ,
										},
									});
									swpList.push( swiperOption2);
								});

							}
						}
						swpList.forEach(swp => {
							swp.update();
						});
					}
					,
					makeMessageAlert : function(messageObj) {
		    			this.$root.$emit( "notiMessage" ,   messageObj  );
	            	},
	            	
	            	sideSoldOutClass : function(prodStatus) {
	            		//console.log("######## prodStatus : " + prodStatus);
                     	if(prodStatus == "4") return true;
                     	else return false;
	            	},
	            	
	            	clickSideMiners : function(idx){
	            		var vsVal = $("#outcome_" + idx).val();
	            		if(vsVal == "0"){
	            			return;
	            		}
	            		var vbChkVal = $("#outcome_" + idx).parent().parent().children('input').prop("checked");
	            		if(vbChkVal && vsVal == "1"){ // 체크박스가 선택되어 있고, 수량이 1일 때 리턴한다. 0으로 내릴수 없음.
	            			return;
	            		}
	            		vsVal--;
	            		$("#outcome_" + idx).val(vsVal)
	            	},
	            	clickSidePlus : function(idx){
	            		var vsVal = $("#outcome_" + idx).val();
	            		if(vsVal == "0"){
	            			return;
	            		}
	            		vsVal++;
	            		$("#outcome_" + idx).val(vsVal)
	            	}
				}

				, updated : function () {
					util.logInfo('side updated');
					this.applySideCssStyle();
				}
				, beforeUpdate : function(){
		            util.logInfo('side beforeUpdate');
		        }

		};///end let template
		return template;
	}

	this.orderListComponent = function () {
		let swiperFood , swiperCategory , swpFoodFlag = false /** 상품분류 클릭여부, 클릭했을때는 최상단으로 보낸다.**/ ;
		let vatCd        = util.GetEnvXmlShopENV(128) /** 사업자 과세 구분 0 : 별도, 1 : 포함. **/		
		  , viewListType = "1"  /** 이미지 보여질 형태. 0 - 일반 , 1 - 확대 **/
		;		
		try {
			viewListType =  parseInt( util.GetEnvXmlPosENV ( 916 ) )  ; /**  0 - 일반 , 1 - 확대 **/
			
			if( Number.isInteger(viewListType) ) {
				viewListType++;
			} else {
				viewListType = 1;
			}
		} catch (e) {
			util.logError(e);
		}
		
		let retryCount = 0;
		let tmplate = {
			      template: '#orderMenu'
			    , data : function() {
			    		  util.logInfo("orderMenu data ...");
			    		  let obj = {
				    			tucls       : []  /** 제품분류정보    **/
				    		  , prodList    : []  /** 판매상품 정보   **/
				    		  , orderList   : []  /** 주문상품 정보   **/
				    		  , sideGrpList : []  /** SIDE 그룹정보   **/
				    		  , sideList    : []  /** SIDE LIST 정보  **/
				    		  , totalAmount : 0  /** 결제금액        **/
				    		  , prodSide    : []  /** 사이드 상품정보 **/
				    		  , totalAmountView : "0"
			    			  , isPayAbleBtn : false /** 결제 버튼 활성화 비활성. **/
			    			  , POS_ODHDR_T : {}  /** 결제페이지로 넘길때설정 정보. **/
			    		      , KITCHEN_MEMO  : ""  /** 수령방법( takeout | eat ) **/
			    			  , listType    : "swiper-container food_listWrap uiType" + viewListType
			    			  , prodAllList : [] /** 전체 데이터 담는다. **/
			    		      , prodBarAllList : [] /** 전체 바코드데이터 담는다. **/
			    		      , menuFontSmallFlag : "N" /** 중메뉴를 클릭했을 때만(메뉴가 새로 그려지는 기준점) Y로 변경하여 폰트를 바꿔준다. **/
			    		      , menuFontClass : "name" /** name이면 기본폰트 nameSmall이면 작은 폰트의 class가 적용된 상태**/	  
		    		    	  , topMenuType : "food_list_menu_wrap menu_list_line1" /** 상단메뉴분류타입 oneLine : 1줄, twoLine : 2줄 **/	  
	    		    		  , topMenuListType : "layout select_menu select_menu_default" /** 주문화면 메뉴스타일타입  : 기본, 큰메뉴, 베스트메뉴 **/
	    		    			//830 - 이미지 2개 스페셜 화면 ( 0- 미사용 , 1-사용 )
    		    				//831 - 사이드화면 ( 0-미사용, 1-상품설명, 2-상품설명+이미지)
    		    				//832- 베스트 메뉴 ( 0 - 미사용, 1-사용 )
    		    			  , viewBestType : "" /**  0 - 미사용, 1-사용 **/
    		    			  , menuType : ""
		    				  , sideType : ""
	    					  , bestType : ""
	    					  , callCnt : 0	 
	    					  , tmpHtml : ""
    						  , topRealList : []
			    		      , vsEatTakeOutVal : SHOP_INFO.SHOP_TYPE
			    		      , vsCouponVal : SHOP_INFO.COUPON_VAL
			    		      , couponPayType : "D" /** 쿠폰 결제 타입 D : 쿠폰비밀번호 , I : 이퀴니스서버 **/
			    		      , couponBarcode : ""
			    		      , prodStatusChgMode : gProdStatusChgMode	  
			    		      , shopUntactType : "0" /** 무인샵 타입 **/
			    		      , totalProdCnt : 0	  
			    		      , totalProdCntView : ""	  
		    		    	  , barcodeCameraId : ""	  
	    		    		  , orderOnly : gvOrderOnly	// 주문전용 키오스크 여부(포스설정용)  0: 미사용, 1: 주문전용, 2 : 판매_주문전용 
	    		    		  , orderMenuStyle : { display : 'none' }
			    		      , voucherMenuStyle : { display : 'none' }
			    		      , menuStyle : undefined
			    		      , indexBarcodeVal : ""
		    		    	  , preventClickProd : "N"
  			    		  }
			    		  if ( obj.listType.indexOf("uiType1") != -1 ) {
			    			  obj.slidesPerView   = 4;
			    			  obj.slidesPerColumn = 4;
			    			  obj.spaceBetween   = 20;
			    		  } else {
			    			  obj.slidesPerView   = 3;
			    			  obj.slidesPerColumn = 4;
			    			  obj.spaceBetween   = 20;
			    		  }
			    		  
			    		  
			    		  obj.lang_all_clear_btn   = util.languageObjReturn(langCode, 'allClearBtn');
			    		  obj.lang_menu_select_msg = util.languageObjReturn(langCode, 'menuSelectMsg');
			    		  obj.lang_pay_btn         = util.languageObjReturn(langCode, 'menuPayBtn');
			    		  obj.lang_order_btn       = util.languageObjReturn(langCode, 'order');
			    		  obj.barCodeMsg      	   = util.languageObjReturn(langCode, 'barCodeMsg');
			    		  obj.product      		   = util.languageObjReturn(langCode, 'product');
			    		  obj.prodCnt      		   = util.languageObjReturn(langCode, 'prodCnt');
			    		  obj.price      		   = util.languageObjReturn(langCode, 'price');
			    		  obj.selfBarcode      	   = util.languageObjReturn(langCode, 'selfBarcode');
			    		  obj.totalQuantity        = util.languageObjReturn(langCode, 'totalQuantity');
			    		  obj.msgPaymentBalance    = util.languageObjReturn(langCode, 'msg_payment_balance');
			    		  obj.orderUnit    		   = util.languageObjReturn(langCode, 'orderUnit');
			    		  
			    		  //판매+주문전용일떄
			    		  if(gvOrderOnly == "2") {
			    			  obj.lang_coupon_btn = util.languageObjReturn(langCode, 'adminOrder');
			    		  } else {
			    			  obj.lang_coupon_btn = util.languageObjReturn(langCode, 'deliveryCoupon');			    			  
			    		  }
			    		  
			    		  return obj;
			    	  }
                , created : function(){
                        util.logInfo("*** orderMenu created >> 메뉴화면 진입!!!");
                        util.logInfo("this.$route.params.id : " + this.$route.params.id );
                        util.logInfo("this.$route.params.memberServiceCls : " + this.$route.params.memberServiceCls );
                        
						//전체 상품데이터 처리 변경 - 20231018 , WDH
						//로봇머신 Soldout 및 커반 멤버십할인에 따른 가격변경을 위해 처리
						// if(gsSpecialShopFlag == "5" || gsSpecialShopFlag == "7" || gsSpecialShopFlag == "9")
						// {
						// 	util.logInfo("*** orderMenu created >> 무인매장 메뉴 RELOAD 처리!!!");
						// 	gProdAllList = orderMenuService.getProductData(null , langCode , vatCd);
						// }

						util.logInfo("*** orderMenu created >> 무인매장 메뉴 RELOAD 처리!!!");
						gProdAllList = orderMenuService.getProductData(null , langCode , vatCd);

                        
						//하단의 2설정은 계속 사용되므로 주석처리 않는다 - 20231018 , WDH
						this.shopUntactType = (util.GetEnvXmlPosENV ( 728 ) || "0" ) /**  샵타입 기존매장 : 0- 미사용 , 무인매장 : 1 **/
                        this.indexBarcodeVal = (util.GetEnvXmlPosENV ( 718 ) || "0" ) /**  셀프계산대 대기화면 바코드 인식 기능 : 0- 미사용 , 사용 : 1 **/

						//기존 코드 주석처리 - 20231019 , WDH
//                        if(this.shopUntactType != "0" || this.indexBarcodeVal != "0") {
//            				this.prodBarAllList = orderMenuService.getProductDataForBarcode(null , langCode , vatCd);
//            			}

                        
                        if(SHOP_INFO.CORNER_PAY_TYPE == "0"){
                			this.tucls = orderMenuService.getKioskClsData(langCode);//분류 데이터 추가.
                		} else {
                			//this.tucls = orderMenuService.getKioskClsData(langCode);//분류 데이터 추가.

                			this.tucls = orderMenuService.getKioskClsDataForCornerPay(langCode, gProdAllList);//분류 데이터 추가.
                		}

						// 터치키분류 반복적용 설정..
						this.tucls = orderMenuService.getKioskClsDataRepeatedApplication(this.tucls);
                    	
                    	//this.prodList = this.prodAllList;
                    	
                        
                        //this.shopUntactType = "1";
                    	this.menuType = (util.GetEnvXmlShopENV ( 830 ) || 0 ) /**  큰메뉴 사용유무 : 0- 미사용 , 1-사용 2-혼합 **/                    	
		    			this.bestType = (util.GetEnvXmlShopENV ( 832 ) || 0 ) /**  베스트상품 사용유무 : 0 - 미사용, 1-사용 **/
                    	
		    			util.logInfo("sideType : " + typeof sideType);
                    	util.logInfo("bestType : " + typeof bestType);
                    	if(SHOP_INFO.TOP_MENU_TYPE == "0") { //상단 메뉴타입 1줄일떄
                    		this.topMenuType = "food_list_menu_wrap menu_list_line1";
                    		if(this.menuType == 1) { //상품메뉴 큰화면2개
                        		this.topMenuListType = "layout select_menu select_menu_bigmenu";
    			    		} else { //상품메뉴 기본화면
    			    			this.topMenuListType = "layout select_menu select_menu_default";
    			    		}
                    	} else { //상단 메뉴타입 2줄일떄
                    		let tempTucls = util.clone(this.tucls)
                    		this.topRealList = this.makeTopCategoryList(tempTucls);
                    		//if(tempTucls.length < 7) {}
                    		this.topMenuType = "food_list_menu_wrap menu_list_line2";
                    		if(this.menuType == 1) {
                        		this.topMenuListType = "layout select_menu select_menu_bigmenu";
    			    		} else {
    			    			this.topMenuListType = "layout select_menu select_menu_default";
    			    		}
                    	}
                    	
                    	if(this.tucls.length > 0 && this.tucls[0].BEST_PROD_YN == "Y" && gsTuClsAll != "1" && this.bestType == 1) {
                    		//주문화면 처음 로딩될 때 상단카테고리 리스트중 첫번쨰가 베스트화면일 경우 베스트 상품 css로 세팅
                    		//상단카테고리중 첫번쨰가 ALL이 아닐경우
                    		this.topMenuListType = "layout select_menu select_menu_horizontal";
                    		this.viewBestType = "select_menu_horizontal"; 
                        	this.listType = "swiper-container food_listWrap uiType1";
                        	this.slidesPerView   = 4;
		    		  		this.slidesPerColumn = 1;
		    		  		this.spaceBetween   = 20;
                    	}
                    	
                    	swpFoodFlag = false; // 위의 clickClsRow에서 true를 시켜주는데, 맨 초반에는 다시 false를 시켜야해서 추가. clickClsRow를 created에서 호출하지 않았으나, 필터링 문제로 추가하면서 해당 false를 추가하게됨
                    }
				, path : ':id'   /**포장하기 or 먹고가기 받는값.**/
				, beforeDestroy () {
						delete this.prodAllList;
						delete this.prodList;
						delete this.POS_ODHDR_T;
						delete this.tucls;
						delete this.orderList;
						delete this.sideGrpList;
						delete this.sideList;
						delete this.prodSide;
						
						this.$root.$off('sideMenuResult' );
						this.$root.$off('notiChoiceResult' );

						this.$root.$off('barcodeScannerResult' );
						this.$root.$off('barcodeScannerResultFail' );
						this.$root.$off('cupPopResult' );
						
						clearInterval(this.barcodeCameraId); // timeoutIdImg 타임아웃 제거

						if(this.shopUntactType != "0" || this.indexBarcodeVal != "0") {
							clearInterval(this.barcodeCameraId); // timeoutIdImg 타임아웃 제거
						}
					}

				, mounted : function() {
						if ( util.isTizen() == false ) {
	                	}else{
		            		if(gAspLogoUseYn == "Y"){ // 사용자 상단로그 사용이라면 URL을 교체한다.
		            			util.logInfo("***** logoOrder LOGO SRC == > " + logoFileUnzipPath + "/userLogo." + gAspLogoExt);
		            			$("#logoOrder").attr("src", logoFileUnzipPath + "/userLogo." + gAspLogoExt); // 사용자 이미지인 경우에 이미지에 글자 안 보이도록 
		            		}else{
		            			util.logInfo("***** logoAdmin LOGO SRC == > ./images/logofiserv.png");
		            			$("#logoOrder").attr("src", "./images/logofiserv.png"); // 사용자 이미지가 아닌 경우에 fiserv 로고 나오도록
		            		}
	                	}
						
				        if(this.$route.params.beforePage == "notifyTalk" && !util.isEmptyStr(basicOrderInfo.notifyTalkPhoneNo)){
				            this.fnClickNotifyTaklPopup();
				        }

						//console.clear();
                        util.logInfo('orderMenu mounted');
                        waitingService.ResetLogOutTimer(); // 대기 동영상 타임아웃 시작.
                		try {
    						//b2bbarcode.stopScanBarcode();
                			if(this.shopUntactType != "0" || this.indexBarcodeVal != "0") {
                				//this.barcodeCameraId = setInterval(this.fnStartBarCodeReader, 100);
                				//setTimeout(this.fnStartBarCodeReader, 1000); // 카메라 활성화 1초후에 시작.
                				
                				if(util.isTizen() === false ) {
                    				setTimeout( this.fnStartBarCodeReader ,2000);
                    			} else {
                    				setTimeout( ()=> {
                    					this.fnStartBarCodeReader();
                    				}, 500)
                    			}
                			}
                			
//                			if ( isFirst == true ) {
//                    			if(util.isTizen() === false ) {
//                    				setTimeout( this.fnStartBarCodeReader ,2000);
//                    			} else {
//                    				setTimeout( ()=> {
//                    					this.fnStartBarCodeReader();
//                    				}, 500)
//                    			}
//                    			isFirst = false;
//                    		}
                			
    					} catch (e) {
    						util.logError('## error barcode camera 바코드 승인났는데 카메라 안꺼짐.');
    						util.logError(e);
    					}
    					// create에서 메뉴화면 그리는 부분을 분기하였으나, create에서는 화면이 다 그려지지 않아 객체 속성변경이 안되어, mount에 css관련된 부분만 따로 적용.
    					if(!gsTuClsAll || gsTuClsAll == "0"){ // 환경설정에서 분류 All을 보이지 않게 설정되어있다면 All을 안보이게 처리하고 렌더링하지 않는다.
                    		//$("#tuClsAll1").hide(); // 위에 All 환경변수가 사용안함인 경우 hide시킨다.
                    		
                    		//상단 2중메뉴일때는 화면을 그려줄때 첫번째 카테고리에 class on을 추가해주기 때문에
                    		//상단 메뉴가 1줄일때만 class on을 따로 추가해준다
                    		if(SHOP_INFO.TOP_MENU_TYPE == "0") {
                    			$("#tuClsAll2").hide();  // 위에 All 환경변수가 사용안함인 경우 hide시킨다.
                    			var vsClsCd = "#" + this.tucls[0].TU_CLS_CD;
                    			$(vsClsCd).toggleClass("on");
                    		}
                    	}else{
                    		//$("#tuClsAll1").show(); 
                    		$("#tuClsAll2").show();
                    	}
    					
    					this.menuStyle = this.$route.params.id;
    					
    					if(this.menuStyle != undefined && this.menuStyle != "voucher") {
    						this.applyCssStyle();
    						this.prodOnceApplyCssStyle();
    						this.fncSwiperEventUpdate();
    					} else {
    						this.applyCssStyle();
    						this.prodOnceApplyCssStyle();
    						this.fncSwiperEventUpdate();
    						this.orderMenuStyle = { display : 'block' };
    					}

                    	util.logInfo("this.$route.params.id : " + this.$route.params.id );
         

                    	eventBus.$on("barcodeScannerResult" , obj => {

                    		util.logInfo("barcodeScannerResult :" + obj.prodCd);
                    		
                    		var tempProdList = [];
                    		
                    		if(!util.isEmpty(gStore_BarcodeProdlist))
							{
								util.logInfo("바코드 상품 기존 데이터 로드 완료!!! ");

                    			//filter하게되면 카테고리별로 같은 상품이 중복으로 존재
                    			//tempProdList = this.prodBarAllList.filter(p => p.PROD_CD == obj.prodCd );
								tempProdList = gStore_BarcodeProdlist.filter(p => p.PROD_CD == obj.prodCd );

								// //filter -> for 문 변경
								// util.logInfo("prodBarAllList length : " + this.prodBarAllList.length );
								// for(let i=0; i < this.prodBarAllList.length; i++)
								// {
								// 	if(this.prodBarAllList[i].PROD_CD == obj.prodCd )
								// 	{
								// 		util.logInfo("matching and Break");
								// 		tempProdList.push(this.prodBarAllList[i]);
								// 		break;
								// 	}
								// }
								  
                    			
								if(tempProdList.length > 0){
                    				// 수량별로 항목추가 obj.EA : 상품수량
                    				//util.logInfo("tempProdListm Ret :" + JSON.stringify(tempProdList[0]));
                    				this.clickProdRow(tempProdList[0]);
                    			}
                    			
                    			if(this.shopUntactType != "0" || this.indexBarcodeVal != "0") {
                    				setTimeout(this.fnStartBarCodeReader, 1000); // 카메라 활성화 1초후에 시작.
                    			} 
                    			
                        		waitingService.ResetLogOutTimer(); // 대기 동영상 타임아웃 시작.
                    		} else {
                    			if(this.shopUntactType != "0" || this.indexBarcodeVal != "0") {
									util.logInfo("바코드 상품 최초 LOAD 시작 !!!! ");
                    				//this.prodBarAllList = orderMenuService.getProductDataForBarcode(null , langCode , vatCd);
									gStore_BarcodeProdlist = orderMenuService.getProductDataForBarcode(null , langCode , vatCd);
                    				tempProdList = gStore_BarcodeProdlist.filter(p => p.PROD_CD == obj.prodCd );

                        			if(tempProdList.length > 0){
                        				// 수량별로 항목추가 obj.EA : 상품수량
                        				//util.logInfo("tempProdList Result :" + JSON.stringify(tempProdList[0]));
                        				this.clickProdRow(tempProdList[0]);
                        			}
                        			
                        			if(this.shopUntactType != "0" || this.indexBarcodeVal != "0") {
                        				setTimeout(this.fnStartBarCodeReader, 1000); // 카메라 활성화 1초후에 시작.
                        			}
                            		waitingService.ResetLogOutTimer(); // 대기 동영상 타임아웃 시작.
                    			}
                    		}
																				           	
                    		
                    	});
                    	
                    	eventBus.$on("barcodeScannerResultFail" , obj => {
                    		util.logInfo("barcodeScannerResultFail!!!");
                    		
                			setTimeout(this.fnStartBarCodeReader, 1000); // 카메라 활성화 1초후에 시작.
                			waitingService.ResetLogOutTimer(); // 대기 동영상 타임아웃 시작.
                    	});
                    	
                    	this.$root.$on("sideMenuResult" , obj => {
                    		util.logInfo("sideMenuResult \n" , obj);
    						this.sideSelectedProcess(obj);
                    	});
                    	this.$root.$on("notiChoiceResult" , obj => {
                    		util.logInfo("notiChoiceResult (삭제 or OK)  : " + obj);
                    		this.cartAllClearProcess(obj);
                    	});
                    	this.$root.$on("couponBarCodeItems" , obj => {
                    		util.logInfo("couponBarCodeItems : " + obj);
                    		this.couponBarcode = obj.barcode;
                    		//이퀴니스 쿠폰조회
                    		this.couponPayType = "I";
                    		this.addCouponProd(obj.items);
                    	});
                    	
                    	// 컵 보증금 상품인 경우에 매장컵, 텀블러, 1회용컵 팝업 선택 후 해당 항수로 진입.
                    	this.$root.$on("cupPopResult" , obj => {
                    		util.logInfo("컵 선택 팝업 후 콜백 : " + obj);
                    		this.cupPopCallback(obj); // 상품 선택했을 때 함수 호출.
                    	});                    	
                    	
                    	// 제휴할인을 하고 뒤로온 경우에, HD, DTL이 기존데이터를 기반으로 이어서 진행되면 부가세 및 기타 계산이 바뀌어 초기화를 시키기 위해 pos_odhdr_t를 빈값으로 변경한다. 기존 내역을 담지 않고 아래 orderInfo를 초기화하는 로직을 태우기 위해
                    	if(orderInfo.POS_ODJCD_T !== undefined){
                    		orderInfo.POS_ODHDR_T = "";                    		
                    	}       
                    	if ( util.isEmpty( orderInfo.POS_ODHDR_T ) ){
                    		this.KITCHEN_MEMO = this.$route.params.id;
                    	} else {
                    		this.POS_ODHDR_T = orderInfo.POS_ODHDR_T  ;
                    		this.orderList   = orderInfo.POS_ODDTL_T   ;
                    		this.KITCHEN_MEMO  = orderInfo.POS_ODHDR_T.KITCHEN_MEMO		  ;  // - KITCHEN_MEMO(string)   : 수령방법( takeout | eat )
                    		this.resetPayInfo();
                    	}
                    	
                    	if(!gsTuClsAll || gsTuClsAll == "0"){ // 환경설정에서 분류 All을 보이지 않게 설정되어있다면 All을 안보이게 처리하고 렌더링하지 않는다.
                    		if(!util.isEmpty(this.$route.params.memberServiceCls)) {
                            	util.logInfo("this.$route.params.memberServiceCls : " + JSON.stringify(this.$route.params.memberServiceCls));
                            	this.clickClsRow(this.$route.params.memberServiceCls);
                            	$('.food_categoryWrap button').removeClass('on');
                                $("#" + this.$route.params.memberServiceCls.TU_CLS_CD).addClass('on');
                            } else {
                          		this.clickClsRow(this.tucls[0]);
                            }
                    	}else{
                    		if(!util.isEmpty(this.$route.params.memberServiceCls)) {
                            	util.logInfo("this.$route.params.memberServiceCls : " + JSON.stringify(this.$route.params.memberServiceCls));
                            	this.clickClsRow(this.$route.params.memberServiceCls);
                            } else {
                            	this.clickClsRow();
                            }
                    	}
                    	
                    	
                    	
//                    	this.prodOnceApplyCssStyle();
//						this.fncSwiperEventUpdate();
                    	//this.menuFontChange(); // 메뉴명이 세줄이 넘어가면 폰트를 줄이도록 하는 함수.
                    	// 상품을 선택해주세요 음성추가.
                    	//var paramSrc = "./audio/48.mp3";
         			    // string으로 보내면 해당 src한건 수행, 배열로 보내면 배열만큼 연속적으로 음성안내 수행 (한글src만 보내면됨)
         			    
                    	//util.fnAudioPlay(paramSrc); // 음성안내 공통함수 호출
                    	
         			    /********************************************
         			     * 2020.11.11 추가.
         			     * orderInfo 는 초기화 한다.
         			     * 결제화면에서 현재 화면으로 이동시 
         			     * 기존 적립포인트 처리 부분이 남아있다.
         			     ********************************************/
         			   orderInfo = {};
         			   
                  	if(this.menuStyle == "voucher") {
                      		//this.voucherMenuStyle = { display : 'block' };
                  		util.logInfo("______________ (상품결제)이퀴니스 바코드입력 버튼 선택 _______________" )
                    	this.$router.push({ path : '/couponBarcode' });
                  	} else {
                  		var paramSrc = "./audio/48.mp3";
         			    // string으로 보내면 해당 src한건 수행, 배열로 보내면 배열만큼 연속적으로 음성안내 수행 (한글src만 보내면됨)
                    	util.fnAudioPlay(paramSrc); // 음성안내 공통함수 호출
                    	
                  		this.orderMenuStyle = { display : 'block' };
                  	}
                  	
					  
					if(kerbanVoiceRecognitionOrders.length > 0){
						util.logInfo('커반 음성인식 주문.....');
						// util.logInfo('kerbanVoiceRecognitionOrders' + JSON.stringify(kerbanVoiceRecognitionOrders));
						// util.logInfo('전체메뉴 :: gProdAllList ' + JSON.stringify(gProdAllList));
						var vOordersList = [];
						
						kerbanVoiceRecognitionOrders.forEach(orderObj => {
							gProdAllList.forEach(prodObj => {
								if(orderObj.itemCd == prodObj.PROD_CD){
									prodObj.device_id = orderObj.deviceId;
									prodObj.pos_id = orderObj.posId;
									prodObj.order_id = orderObj.orderId;
									prodObj.item_count = orderObj.itemCount;
									vOordersList.push(prodObj);
								}
							});							
						});

						// PROD_CD 중복체크..
						vOordersList = [ ...new Map(vOordersList.map((obj) => [obj["PROD_CD"], obj])).values() ];
						
						util.logInfo('ordersList' + JSON.stringify(vOordersList));
						if(vOordersList.length > 0){
							util.logInfo('음성인식 메뉴선택..');
							vOordersList.forEach(element => {

								if(Number(element.item_count) > 1) {
									for(var j=0; j < Number(element.item_count); j++){
										this.clickProdRow(element); 
									}
								} else {
									this.clickProdRow(element); 
								}

							});

							/*
							vOordersList.forEach(element => {
								var delParam = {
									'DEVICE_ID' : element.device_id,
									'POS_ID' : element.pos_id,
									'ORDER_ID' : element.order_id
								};
								var delRst = util.ajaxCallKerbanVoiceRecognitionDel(delParam); // 커반 음성인식 주문정보 삭제..

								if(delRst.code == '200'){
									vOordersList = vOordersList.slice(vOordersList.indexOf(element));
									// console.log('vOordersList',vOordersList);
								}

							});
							*/

							var delParam = {
								"deviceId" : gShopCd,
								"posId" : gPosNo
							};

							// 커반 음성인식 주문정보 삭제.. 전체 삭제로 변경됨..
							var delRst = util.ajaxCallKerbanVoiceRecognitionDel(delParam);
							if(delRst.code === 'SUCCESS'){
								util.logInfo(" 커반 음성인식 주문삭제 성공 !! " );
							}else{
								util.logInfo(" 커반 음성인식 주문삭제 실패 !! " );
							}
							vOordersList = []; // 초기화..


						}else{
							util.logInfo('일치하는 메뉴없음...');							
						}

						kerbanVoiceRecognitionOrders = []; // 초기화..

					}

         			   
                 }
                , methods :{						
                    	fncSwiperEventUpdate : function(){
							//console.clear();
							//선택메뉴리스트
                    		util.logInfo('fncSwiperEventUpdate');
                    		
                    		if(this.shopUntactType == "0") swiperFood.update();
                    		//swiperCategory.update();
                    	}
                    	,
                    	prodOnceApplyCssStyle : function() {
                    		//swiperFood = undefined;	
                            //개발참고사항 :: 카테고리버튼 스타일 적용
                            $('.food_categoryWrap button').click(function(){ //[수정] 2020-06-26
                                $('.food_categoryWrap button').removeClass('on');
                                $(this).addClass('on');
                            });


                            if(this.topMenuType == "food_list_menu_wrap menu_list_line1") {
                            	swiperCategory = new Swiper('.food_categoryWrap', {
                                	slidesPerView: 4, // 2020-12-15 백종기 수정. 메뉴리스트의 중메뉴를 4개로 변경
                                	grabCursor: true,
                                	navigation: {
                                		nextEl: '.category_next',
                                		prevEl: '.category_prev',
                                	},
                                });
                            } else { 
                            	// twoLine - 2줄일때
                            	// slidesPerColumnFill='row'
                            	// row option일때
                            	// 1 2 3 4 
                            	// 5 6 7 8
                            	// row option아닐때
                            	// 1 3 5 7
                            	// 2 4 6 8
//                            	if (typeof(swiperCategory) !== "undefined" ) {
//                            		swiperCategory.destroy(true, true);
//                            		swiperCategory = undefined;
//                                }
                            	swiperCategory = new Swiper('.food_categoryWrap', {
                            		slidesPerView: 4, // 2020-12-15 백종기 수정. 메뉴리스트의 중메뉴를 4개로 변경
                                	grabCursor: true,
//                                	slidesPerView: 4, // 2020-12-15 백종기 수정. 메뉴리스트의 중메뉴를 4개로 변경
//                                	slidesPerColumn : 2,
//                                	slidesPerColumnFill: 'column',
//                                	slidesPerGroup: 2,
                                	navigation: {
                                		nextEl: '.category_next',
                                		prevEl: '.category_prev',
                                	},
                                });
                            }
                            
                            //this.listType = "swiper-container food_listWrap uiType" + viewListType;
                            util.logInfo("this.topMenuListType >>> " + this.topMenuListType);
                            util.logInfo("this.listType >>> " + this.listType);
                            util.logInfo("this.viewBestType >>> " + this.viewBestType);
                            util.logInfo("this.swiperFood >>> " + swiperFood);
                            
                            if ( this.listType.indexOf("uiType1") != -1 ) {
                            	this.slidesPerView   = 4;
  			    			  	this.slidesPerColumn = 4;
  			    			  	if(this.topMenuListType == "layout select_menu select_menu_bigmenu"){
  			    			  		this.spaceBetween = 20;
  			    			  	} else {
  			    			  		this.spaceBetween = 20;
  			    			  	} 
  			    		  	} else {
  			    		  		this.slidesPerView   = 3;
  			    		  		this.slidesPerColumn = 4;
  			    		  		this.spaceBetween   = 20;
  			    		  	}
                            
                            if(this.topMenuListType == "layout select_menu select_menu_horizontal"){
                            	//this.listType = "swiper-container food_listWrap uiType1";
                            	this.slidesPerView   = 4;
  			    		  		this.slidesPerColumn = 1;
  			    		  		this.spaceBetween   = 20;
                            } 
                            
                            try {
                            	//상단 상품 카테고리 클릭할때 마다 swiper의 적용방식이 달라질수있지만 기존에 적용된
                            	//swiper가 정상적으로 적용안되는 현상 때문에 기존에 적용된 swiper를 destroy를 먼저 해준다
                            	if (typeof(swiperFood) !== "undefined" ) {
                                	swiperFood.destroy(true, true);
                                	swiperFood = undefined;
                                }
                                
							} catch (e) {
								swiperFood = undefined;
							}
                            
                            
                            swiperFood = new Swiper('.food_listWrap' , {
                        		direction: 'vertical',
                        		slidesPerView   : this.slidesPerView   ,
                        		slidesPerColumn : this.slidesPerColumn ,
                        		spaceBetween    : this.spaceBetween    ,
                        		navigation: {
                        			nextEl: '.food_next',
                        			prevEl: '.food_prev',
                        		},
                            });
                            
                    	}
                    	,
                    	// 분류 클릭 함수.
                    	clickClsRow : function (row, soundYn ) {
                    		//this.callCnt = 0;
                    		util.logInfo('orderMenu > clickClsRow : ' + JSON.stringify( row ) );
                    		if(soundYn == "Y"){
                    		}
                    		this.sideVariableInit();//SIDE 정보 초기화

                    		//this.clickClsRow2(row);
                    		
                    		if( row != null && row.TU_CLS_CD != undefined  ) {
                    			
                    			if (row.BEST_PROD_YN == "N" ) {
                    				if(SHOP_INFO.TOP_MENU_TYPE == "0") {
                                		//this.topMenuType = "food_list_menu_wrap menu_list_line1";
                                		if(this.menuType == 1) {
                            				this.topMenuListType = "layout select_menu select_menu_bigmenu";
                			    		} else {
                			    			//큰메뉴 및 기본메뉴 혼합 사용 매장이면서  KIOSK터치키 등록에서 영문명이 recommnad이면 큰메뉴로 노출
                			    			if(row.REC_PROD_YN == "Y" && this.menuType == 2) {
                                				this.topMenuListType = "layout select_menu select_menu_bigmenu";
                                			} else {
                                				this.topMenuListType = "layout select_menu select_menu_default";
                                			}
                			    		}
                                	} else {
                                		//this.topMenuType = "food_list_menu_wrap menu_list_line2";
                                		if(this.menuType == 1) {
                            				this.topMenuListType = "layout select_menu select_menu_bigmenu";
                			    		} else {
                			    			//큰메뉴 및 기본메뉴 혼합 사용 매장이면서  KIOSK터치키 등록에서 영문명이 recommnad이면 큰메뉴로 노출
                			    			if(row.REC_PROD_YN == "Y" && this.menuType == 2) {
                                				this.topMenuListType = "layout select_menu select_menu_bigmenu";
                                			} else {
                                				this.topMenuListType = "layout select_menu select_menu_default";
                                			}
                			    		}
                                	}
                    				this.viewBestType = "";
                    				this.listType = "swiper-container food_listWrap uiType" + viewListType;
                    			} else {
                    				if(SHOP_INFO.TOP_MENU_TYPE == "0") {
                                		//this.topMenuType = "food_list_menu_wrap menu_list_line1";
                                		if(this.bestType == 1) {
                                			this.topMenuListType = "layout select_menu select_menu_horizontal";
                                			this.viewBestType = "select_menu_horizontal";
                                			this.listType = "swiper-container food_listWrap uiType1";
                                		}
                                	} else {
                                		//this.topMenuType = "food_list_menu_wrap menu_list_line2";
                                		if(this.bestType == 1) {
                                			this.topMenuListType = "layout select_menu select_menu_horizontal";
                                			this.viewBestType = "select_menu_horizontal";
                                			this.listType = "swiper-container food_listWrap uiType1";
                                		}
                                	}
                    				
                    			}
                    			
                    			util.logInfo("click TU cls row.TU_CLS_CD : " + row.TU_CLS_CD  + "  row.TU_CLS_NM (메뉴 분류) : "  + row.TU_CLS_NM) ;
                    			//let rows = orderMenuService.getProductData(row.TU_CLS_CD, langCode , vatCd );
                    			//this.prodList = rows;
                    			
								//this.prodList = this.prodAllList.filter(p => p.TU_CLS_CD == row.TU_CLS_CD );
								this.prodList = gProdAllList.filter(p => p.TU_CLS_CD == row.TU_CLS_CD );
								//this.prodList = gStore_ProdAlllist.filter(p => p.TU_CLS_CD == row.TU_CLS_CD );  //변수 수정 - 20231019 , WDH

                    		} else {
                    			
                    			if(SHOP_INFO.TOP_MENU_TYPE == "0") {
                            		//this.topMenuType = "food_list_menu_wrap menu_list_line1";
                            		if(this.menuType == 1) {
                                		this.topMenuListType = "layout select_menu select_menu_bigmenu";
            			    		} else {
            			    			//큰메뉴 및 기본메뉴 혼합 사용 매장이면서  KIOSK터치키 등록에서 영문명이 recommnad이면 큰메뉴로 노출
            			    			this.topMenuListType = "layout select_menu select_menu_default";
            			    		}
                            	} else {
                            		//this.topMenuType = "food_list_menu_wrap menu_list_line2";
                            		if(this.menuType == 1) {
                                		this.topMenuListType = "layout select_menu select_menu_bigmenu";
            			    		} else {
            			    			//큰메뉴 및 기본메뉴 혼합 사용 매장이면서  KIOSK터치키 등록에서 영문명이 recommnad이면 큰메뉴로 노출
//            			    			if(row.REC_PROD_YN == "Y" && this.menuType == 2) {
//                            				this.topMenuListType = "layout select_menu select_menu_bigmenu";
//                            			} else {
//                            				this.topMenuListType = "layout select_menu select_menu_default";
//                            			}
            			    			
                        				this.topMenuListType = "layout select_menu select_menu_default";
            			    		}
                            	}
                    			this.viewBestType = "";
                    			this.listType = "swiper-container food_listWrap uiType" + viewListType;
                    			//this.prodList = this.prodAllList.filter( p => true );
                    			//var vsCnt = this.prodAllList.length;
								var vsCnt = gProdAllList.length;
								
                    			var vaReturnList = [];
                    			var j=0;
                    			for(var i=0; i < vsCnt; i++){ // 상품개수만큼 루프
                    				
                    				if(i==0){
                    					//vaReturnList[j] = this.prodAllList[i];
										vaReturnList[j] = gProdAllList[i];
                    					j++;
                    				}else{
                    					var vsSetYn = "N";
                    					for(var z=0;z<vaReturnList.length;z++){                    						
                    						//if(vaReturnList[z].PROD_CD == this.prodAllList[i].PROD_CD){ // 배열에 이미 같은 상품코드가 존재한다면
											if(vaReturnList[z].PROD_CD == gProdAllList[i].PROD_CD){ // 배열에 이미 같은 상품코드가 존재한다면
                    							vsSetYn = "Y"; // 플래그를 Y로 변경
                    						}                    						
                    					}
                    					if(vsSetYn == "N"){ // 같은 상품이 존재하지 않는 것만
                    						//vaReturnList[j] = this.prodAllList[i]; // 배열에 셋팅
											vaReturnList[j] = gProdAllList[i]; // 배열에 셋팅
                    						j++;                    						
                    					}
                    					
                    				}
                    				
                    			}
                    			this.prodList = vaReturnList;
                    			vaReturnList = [];
                    			//console.log("click TU cls row.TU_CLS_CD 없음 " ) ;
                    			//this.prodList = orderMenuService.getProductData(null, langCode , vatCd);
                    		}
                    		this.menuFontSmallFlag = "Y";
                    		
                    		swpFoodFlag = true;
                    		util.logInfo('*** #orderMenu clickClsRow prodList length : ' + this.prodList.length);
                    		
                    	},
                    	
                    	// 상품클릭
                    	clickProdRow: function ( row ) {                    		                    		
                    		//if(gsSpecialShopFlag == "7" || gsSpecialShopFlag == "9"){ // 매장 판단 - 값이 7or9인 경우 알다방 매장, 레인보우 로보틱스  
//                        		var vnOrderQtySum = util.fnOrderQtySum(this.orderList); // 총 주문 수량이 3개 이하여야 한다.
//                        		if(vnOrderQtySum == 3){
//                        			let dataObj = {};
//                        			dataObj.button2Show = true;
//                        			dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
//                        			dataObj.message = util.languageObjReturn(langCode,  'threeQtyLimit'); // 총 수량 3개 이하만 주문 가능합니다.
//                        			eventBus.$emit('alertPopupIndex', dataObj);
//                        			return false;
//                        		}                        		
//                        	}


							// 셀프계산대 무인매장일때는 이벤트상품 스킵처리
							if(this.shopUntactType == '0' && this.indexBarcodeVal == '0'){ // 샵타입 기존매장, 셀프계산대 대기화면 바코드 인식 기능 둘다 미사용일시에만 체크
								let isTuClsProc = false;
	
								this.orderList.forEach(element => {
									// 터치키분류 처리구분 0:단일선택 1:복수선택
									// 카테고리별 단일선택일 경우..
									if(row.TU_CLS_PROC_FG == '0' && (element.TU_FG === row.TU_FG && element.TU_CLS_CD === row.TU_CLS_CD) ){
										isTuClsProc = true;
									}
								});
	
								if(isTuClsProc){
									let dataObj = {};
									   dataObj.button2Show = true;
									   dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
									   dataObj.message =  util.languageObjReturn(langCode,  'tuClsProcMsg'); // '이벤트상품 분류 내에서는 하나의 상품만 선택 가능합니다.'								   
									   eventBus.$emit('alertPopupIndex', dataObj);
									return false;
								}

							}
							
                    		
                    		if(this.preventClickProd == "Y") return;
                    		
                    		if(gSubsMenuHasChk == "Y") {
                    			if(row.MBS_PROD_YN == "N") {
                    				return;
                    			}
                    			this.orderList   = [];
                        		this.sideVariableInit();
                        		this.resetPayInfo();//금액 재산출 및 기타정보 재설정
                    		}
                    		
                    		if(row.MBS_PROD_YN == "Y") { //구독서비스 제품을 선택한 경우
                    			if(gSubsMenuHasChk == "N") {
                    				let dataObj2 = {};
                    				dataObj2.button1Show = true;
                    				dataObj2.button1Name = util.languageObjReturn(langCode, 'no');// [ 아니오 ]
                        			dataObj2.button2Show = true;
                        			dataObj2.button2Func = this.clickProdRow
                        			dataObj2.button2Name = util.languageObjReturn(langCode, 'yes');// [ 예 ]
    								dataObj2.message = util.languageObjReturn(langCode,  'memberServie9');
    								//dataObj2.message = "구독권 상품과 다른 상품은 같이 구입할 수 없습니다. 그래도 진행하시겠습니까?";
    								dataObj2.data = row; 
    								dataObj2.data.subsMenuHasChk = "Y"; 
            						eventBus.$emit('alertPopupIndex', dataObj2);
                        			return;
                    			}
                    		}
                    		
                    		// if(this.couponPayType == "D") {
                    		// 	util.fnTouchAudio(); // 터치할 때 소리 나도록 함수 호출.
                    		// }
                    		if(this.couponPayType == "D") {
								if(kerbanVoiceRecognitionOrders.length == 0){ // 커반음성인식 주문이 없을경우
									util.fnTouchAudio(); // 터치할 때 소리 나도록 함수 호출.
								}
                    		}
                    		
                        	util.logDebug("clickProdRow : "  + JSON.stringify( row )  );
                        	util.logInfo("clickProdRow 상품명 : "  + row.PROD_NM + ", 상품 가격 : " + row.판매단가_출력용);
                        	this.sideVariableInit();//SIDE 정보 초기화
                        	/***************************************************
                        	 * 1. Sold out 인지 체크
                        	 * 2. 옵션상품인지
                        	 *  - 팝업오픈 후 옵션 선택
                        	 *   -> 선택된 옵션들이 모두 같은 제품이 있다면 기존 주문명세에 숫자 + 1
                        	 *   -> 선택된 옵션들이 같은게 없다면 주문명세에 신규 추가.
                        	 * 3. 옵션없는 상품
                        	 *  - 추가된 메뉴가 있다면 +1 , 없다면 신규 등록
                        	 ***************************************************/
                        	if ( this.orderList == null ) {
                        		this.orderList = [];
                        	}
                        	
                        	//상품상태변경 모드 N:일반, A:변경모드
                        	if(gProdStatusChgMode == "N") {
                        		/********************* 품절 *********************/
                        		if ( row.KIOSK_PROD_STATUS == '4') {
                        			util.logDebug("Sold Out >>  : " + row.PROD_NM) ;
                        			var obj = { message : util.languageObjReturn(langCode, 'itemOutOfStock'), messageType : "alert" };
                        			//obj.lang_notice_cancel        = util.languageObjReturn(langCode, 'noticeCancel');
                        			this.$root.$emit("notiMessage" , obj );
                        			$('#noti_message').html("<p>"+obj.message+"</p>");
                        			return;
                        		}
                        		if( (row.SIDE_MENU_YN  == "N" || row.SIDE_MENU_YN  == "") && ( (row.DESCRIPTION_DISP_YN == "N" || row.DESCRIPTION_DISP_YN == "" || row.DESCRIPTION_DISP_YN == null) || (row.DESCRIPTION_DISP_YN == "Y" && ((!row.DESCRIPTION && langCode=="ko") || (!row.DESCRIPTION_EN && langCode=="en")) ) ) ) {
                        			util.logInfo("SIDE Menu 없음 : " + row.PROD_NM) ;
                        			util.logInfo("SIDE row.SIDE_MENU_YN : " + row.SIDE_MENU_YN) ;
                        			util.logInfo("SIDE row.DESCRIPTION_DISP_YN : " + row.DESCRIPTION_DISP_YN) ;
                        			$("#index"+row.PROD_CD).addClass("active");
                        			// 컵보증금 가공 시작.
                            		this.cupSelectProcess(row);
//                        			this.sideHasNotProdAddToCart(row);
                        			
                        		} else {
                        			util.logInfo("SIDE Menu 있음 : " + row.PROD_NM) ;
                        			util.logInfo("SIDE row.SIDE_MENU_YN : " + row.SIDE_MENU_YN) ;
                        			util.logInfo("SIDE row.DESCRIPTION_DISP_YN : " + row.DESCRIPTION_DISP_YN) ;
                        			
                        			let sideGrpList = orderMenuService.getSideMenuGroupList(row , langCode );
//                        		if ( sideGrpList != null && sideGrpList.length != 0 ) {
                        			
                        			let sideList = orderMenuService.getSideMenuDetailList(row , langCode);
//                        			if ( sideList != null && sideList.length != 0 ) {             				
                        			this.prodSide = row;
                        			this.sideGrpList = sideGrpList;
                        			this.sideList = sideList;
                        			
                        			if(!gsSidePopVal){
                        				gsSidePopVal = 0; // 값이 없으면 디폴트 0으로 셋팅.
                        			}
                        			
                        			let sideObj = {
                        					prodInfo    : row
                        					, sideGrpList : sideGrpList
                        					, sideList    : sideList
                        					, menuDiv     : gsSidePopVal // 사이드메뉴 화면 종류 값 
                        			}
                        			
                        			this.$root.$emit('sideMenuList', sideObj);//Side Popup 호출
                        			return;
                        			
//                        			} else {
//                            			util.logInfo("SIDE 있다고 했는데 없음(List 가 없음). 정정 처리.");
//                            			this.sideHasNotProdAddToCart(row);//없기 때문에 side 없는 것으로 처리함.
//                        			}
                        			
//                        		} else {
//                        			util.logInfo("SIDE 있다고 했는데 없음. 정정 처리.");
//                        			this.sideHasNotProdAddToCart(row);//없기 때문에 side 없는 것으로 처리함.
//
//                        		}
                        		}
                        	} else {
                        		util.logInfo("@@@ 상품상태 변경할 제품명 : " + row.PROD_NM) ;
                    			$("#index"+row.PROD_CD).addClass("active");
                    			this.sideHasNotProdAddToCart(row);
                    			var vsResult = util.fnCupDataMng(row, this.orderList, this.totalAmount, this.totalAmountView);
                        		if(vsResult){
                        			this.totalAmount = Number(this.totalAmount) + gCupUprc;
                					this.totalAmountView =  util.numberWithCommas(this.totalAmount);
                        		}
                        	}
                    		
                        }

                    	/********************************************************************************************************************************************
                    	 * SIDE 가 있는 상품에서 선택하고 온 경우 카트 처리 로직
                    	 * SIDE Type  ＠ SDA_CLS_CD (side 대그룹) ＠ SIDE_FG(SIDE 중분류코드)  ＠ SIDE_CLS_CD (사이드 실제코드) ＠ SIDE_UPRC 사이드 가격 ＠ 사이드명칭
                    	 ********************************************************************************************************************************************/
                    	, sideSelectedProcess : function( obj ) {

							let row = obj.prodInfo;
							row = util.clone(row);
							//어디서 ORDER_QTY 값이 reset 되는지 모름.
							if ( row.ORDER_QTY == 0) {
								row.ORDER_QTY++;
							}
							let optList = obj.optList;
							util.logDebug('사이드 선택 ' , obj);
							if ( optList == undefined || optList.null || optList.length == 0 ) {
								//SIDE 가 있는데 선택을 안함
								util.logDebug('SIDE 가 있는데 선택을 안함.');
								row.SIDE_MENU_YN = 'N';//사이드 포함상품도 사이드상품을 선택을 안했기에 없다고 설정.
								this.cupSelectProcess(row);
								//this.sideHasNotProdAddToCart(row);
								return;
							}

							//사이드 합계금액
							let sideSumAmount = 0;
							let sideSumSupplyAmount = 0;//사이드 포함 공급가 합계
							let sideSumVatAmount    = 0;//사이드 포함 VAT    합계
							let sideList = [];
							let sideFullValue = "";
							for ( let i = 0 ;i < optList.length ; i++ ) {
								let optStr = optList[i].split("＠");
								let opt = {
										  사이드중복구분      : optList[i] /** 사이드 상품 전체 문자 ( 차후 비교를 위해서 넣는다.)**/
										, 사이드구분          : optStr[0]
										, SDA_CLS_CD          : optStr[1]  //대
										, SIDE_FG             : optStr[2]  //중
										, SIDE_CLS_CD         : optStr[3]  //소
										, 사이드판매가        : Number(optStr[4])
										, 사이드판매가_출력용 : util.numberWithCommas(Number(optStr[4]) * Number(optStr[12])) 
										, 사이드명            : optStr[5]
										, 사이드INFO_TXT      : optStr[6]
//										, STAMP_ACC_YN      : optStr[7]
//										, STAMP_ACC_QTY      : optStr[8]
//										, STAMP_USE_YN      : optStr[9]
//										, STAMP_USE_QTY      : optStr[10]
										, SIDE_QTY : optStr[12]
										, SIDE_QTY_ORIGIN : optStr[12]
										, SIDE_SALE_UPRC : ""
										, SIDE_DC_AMT : ""
								};
								let optJson = JSON.parse(optStr[6]);
								/**
								 * 2022-07-04 푸드테크 개발로 인한 사이드 메뉴 중 속성에 대한 저장 변경
								 * 기존 : 아래 주석으로 처리한 if문 처럼 속성이 단일 선택일 때, 메인메뉴의 SDA_CD에 해당 속성코드(SIDE_CD)를 담았음.
								 *       단일선택인 경우 메인메뉴의 SDA_CD에만 담고 해당 속성 데이터는 DTL테이블에 저장하지 않았음.
								 *       다중선택인 경우 속성을 DTL테이블에 각각 저장처리하고 있음.
								 * 변경 : 단일선택이라도 메인메뉴의 SDA_CD는 속성코드 값을 담지 않음.
								 *       선택메뉴의 경우에만 SDA_CD에 해당 메뉴커도(SIDE_CD)를 담음
								 *       단일 선택인 경우에도 메인메뉴의 SDA_CD에 속성을 담지 않고, 속성을 DTL테이블에 저장처리하도록 함.
								 *       다중 선택인 경우에도 SDA_CD에는 빈값을 보내도록 함.
								 */
								if ( opt.사이드구분 == 'A') { // 속성
									//util.GetEnvXmlShopENV(532)   0 : 단일 선택 ( 기본값) , 1 : 멀티선택, 2: 단일선택 필수 , 3 : 멀티선택 필수 					        		
//									if(SHOP_INFO.SIDE_SEL_OPTION == "0" || SHOP_INFO.SIDE_SEL_OPTION == "2"){
//										row.SDA_CD = optJson.SIDE_CD; //푸드테크 개발로 인해 사이드[속성]인 경우에는 SDA_CD를 넣지 않고 <TRSOC> 전문에 따로 담아서 전송하기로함.
//									} else {
										//다중선택에서 속성의 상품코드 형식 -> "A" + SDA_CLS_CD + SIDE_CD
										opt.PROD_CD = "A" + optStr[1] + optJson.SIDE_CD;
										if(gsSpecialShopFlag == "8"){
											opt.SDA_CD = ""; //optJson.SIDE_CD; //푸드테크 개발로 인해 사이드[속성]인 경우에는 SDA_CD를 넣지 않고 <TRSOC> 전문에 따로 담아서 전송하기로함.
										} else {
											//기존에 사이드 속성값을 선택할 때 SDA_CD값을 빈값으로 세팅했지만 오더 스크린에서 속성값이 없는경우에 사이드 메뉴를 못받는 상황이라 수정,
											//다른 매장에 영향을 받는지 확인이 필요 -> 영수증 포맷에 영향
											opt.SDA_CD = optJson.SIDE_CD;
											row.SDA_CD = optJson.SIDE_CD;
										}
										opt.VAT = optJson.VAT;
//									}
								} else if( opt.사이드구분 == 'B') { // 선택  
									opt.PROD_CD = optJson.PROD_CD;
									opt.공급가 = Number(optJson.공급가) * Number(opt.SIDE_QTY);
									opt.VAT = Number(optJson.VAT) * Number(opt.SIDE_QTY);
									opt.SIDE_SALE_UPRC = Number(optJson.공급가);
									opt.SDA_CD = optJson.SIDE_CD; // 푸드테크 개발로 인해 사이드[선택]인 경우만 SDA_CD에 SIDE_CD를 넣기로 함.
								}

								sideSumAmount       += Number(opt.사이드판매가) * Number(opt.SIDE_QTY);
								sideSumSupplyAmount += Number(optJson.공급가) * Number(opt.SIDE_QTY);
								sideSumVatAmount    += Number(optJson.VAT) * Number(opt.SIDE_QTY);

								sideList.push(opt);
								sideFullValue += '＠' + row.PROD_CD + '@' + optList[i];

							}

							util.logDebug('side 길이 :  ' , sideList);

							row['사이드포함판매단가']		    = row.판매단가 + sideSumAmount;//판매가격 숫자로 변환
							row['사이드포함판매단가_출력용']	= util.numberWithCommas(row.사이드포함판매단가);//판매가격 Text 로 보여질 값.

							//합계금액 산출
							row['사이드포함_합계금액']			= row['판매단가'] + sideSumAmount  ;//합계금액으로 계산하기 위하여.
							row['사이드포함_합계금액_출력용']	= util.numberWithCommas( row['판매단가'] + sideSumAmount) ;//합계금액을 산출 후 보여줄 Text(사용은 됨)
							
							if(!row['사이드_보증금포함_합계금액']){
								row['사이드_보증금포함_합계금액'] = 0;
							}
							if(!row['사이드_보증금포함_합계금액_출력용']){
								row['사이드_보증금포함_합계금액_출력용'] = 0;
							}
							if(!row['CUP_DEPOSIT_UPRC_SUM']){
								row['CUP_DEPOSIT_UPRC_SUM'] = 0;
							}
							row['사이드_보증금포함_합계금액']	= Number(row['CUP_DEPOSIT_UPRC_SUM']) +  Number(row['판매단가']) + Number(sideSumAmount) ;
							row['사이드_보증금포함_합계금액_출력용']	= util.numberWithCommas(row['사이드_보증금포함_합계금액']);
							

							row['사이드_중복체크값']			= sideFullValue;
							row['사이드_LIST']					= sideList;

							row['사이드_포함_공급가_합계']		= Number(row.공급가) + sideSumSupplyAmount;
							row['사이드_포함_VAT_합계']			= Number(row.VAT   ) + sideSumVatAmount ;

							//중복체크
							/************************************************************
							 *  중복체크
							 * 1. 사이드메뉴가 아니라면 다음 데이터를 비교
							 * 2. 동일제품이 있다면 기존것에 1증가.
							 * 3. 동일제품이 없다면 orderList 에 추가.(push)
							 ************************************************************/
//							let flag = false;
//							let targetObj = null;
//                    		for ( let i = 0 ; i < this.orderList.length ; i++ ) {
//                    			let x5 = this.orderList[i];
//                    			//사이드메뉴가 있는것만 비교한다.
//                    			if ( x5.SIDE_MENU_YN == 'N') {
//                    				continue;
//                    			}
//
//                    			if ( x5['사이드_중복체크값'] == row['사이드_중복체크값']) {
//                    				flag = true;
//                    				x5.ORDER_QTY++  ;
//                    				targetObj = x5;
//                    				util.logDebug('같은게 있어?' +  x5['사이드_중복체크값'] + ' > '+ row['사이드_중복체크값'] );
//                    				break;
//                    			}
//                    		}

//                    		if ( flag == true ) { // 사이드 메뉴가 같으면
//
//                    			this.calcQtyAmount(targetObj);
//
//                    		} else { // 사이드 메뉴가 다르면
//								this.orderList.push(row);
//								$("#index"+row.PROD_CD).addClass("active");
//                    		}
//                    		this.resetPayInfo();
                    		
                    		// 컵보증금 가공 시작.
                    		this.cupSelectProcess(row);
                    		
                    	} //end sideSelectedProcess (사이드 메뉴 후처리 function)

                    	,
                    	/**********************************************************************
                    	 * SIDE 가 없는 상품일 경우 카트 처리 로직
                    	**********************************************************************/
                        sideHasNotProdAddToCart : function ( orgRow ) {
                        	let row = util.clone(orgRow);
                			row.SIDE_MENU_YN = 'N';//사이드 포함상품도 사이드상품을 선택을 안했기에 없다고 설정.
                			let flag = false;//동일제품
                			let cartItemInfo ;
                    		//동일제품 있는지 체크.
                    		for ( let i = 0 ; i < this.orderList.length ; i++ ) {
                    			let x5 = this.orderList[i];
                    			if ( row.PROD_CD == x5.PROD_CD && x5.SIDE_MENU_YN == 'N') {
                    				                    				
                    				// 기존에 선택한 데이터들 중에 cupList가 존재하지 않고(컵종류 없음) 선택한 상품도 cup종류가 없다면 같은 상품이므로 해당상품개수 plus수행
                    				if(!x5.cupList && !row.CUP_TYPE){ 
                    					flag = true;
                        				cartItemInfo = x5;                        					
                    				}else if(x5.cupList && row.CUP_TYPE){ // 기존에 선택했던 상품중에 cupList가 존재하고 해당상품에도 컵종류가 존재한다면 같은 컵종류인지 수행 
                    					for(var j=0; j<x5.cupList.length; j++){
                    						if(x5.cupList[j].CUP_TYPE == row.CUP_TYPE){ // 같은 상품이면서 컵종류가 같은게 존재할 때 해당 row의 상품 개수 plus 수행
                    							flag = true;
                    							cartItemInfo = x5;
                    						}
                    					}                    					
                    				}                    				                    				
                    			}
                    		} //end for

                    		if ( flag == true ) {
                    			this.mainProdPlus(cartItemInfo , 0);
                    			return;
                    		}
                    		
                    		this.calcQtyAmount(row);
                    		this.orderList.push (row);
                    		util.logInfo("this.orderList == > " + this.orderList);

                        	this.resetPayInfo();//금액 재산출 및 기타정보 재설정

                        }
                    	, cupSelectProcess: function (row) {
							
                    		// 실제 사용시에 아래 미사용 0으로 하드코딩한 것 지우면 됩니다. 2022-06-08
                    		row.CUP_DEPOSIT_FG = "0"; // 이거 지우면 됩니다.
                    		///////////////////////
                    		
                    		util.logInfo("_____컵 보증금 선택 시작(cupSelectProcess)_____");
                    		if(row.CUP_DEPOSIT_FG == "0"){ // 미사용인 경우 일반 프로세스 호출.
                    			util.logInfo("_____컵 보증금 선택 미사용_____");
                    			row.CUP_TYPE = "";
                    			return this.cupPopCallback(row);
                    		}else if(row.CUP_DEPOSIT_FG == "1"){ // 해당 상품이 일회용컵 보증금 설정이 '사용여부선택'이라면 컵선택하는 팝업을 호출한다.
                    			util.logInfo("_____컵 보증금 선택 사용여부선택(팝업호출)_____");
//                    			eventBus.$emit('selCupPop', row); // 컵 종류 선택하는 팝업 호출.
                    			this.$root.$emit("selCupPop" , row );	// 팝업에서 컵선택 후 fnCupDataMngAfter 함수 호출하도록 처리됨.	
                    		}else if(row.CUP_DEPOSIT_FG == "2"){ // 1회용컵이 필수인 경우에 값
                    			util.logInfo("_____컵 보증금 선택 필수_____");
                    			row.CUP_TYPE = "disposableCup"; // 일회용컵 셋팅
                    			return this.cupPopCallback(row);
                    		}else{ // 값이 없는 경우에 일반 프로세스 호출.
                    			util.logInfo("_____컵 보증금 선택 else_____");
                    			row.CUP_TYPE = "";
                    			return this.cupPopCallback(row);
                    		}				
                    	}
                    	, cupPopCallback: function (row) {
                    		util.logInfo("_____컵 보증금 선택 후처리 함수 시작_____");
                    		if(row.SIDE_MENU_YN  == "N" || row.SIDE_MENU_YN  == ""){ // 사이드 메뉴가 없는 경우의 상품에 대한 셋팅
                    			util.logInfo("_____컵 보증금 선택 후처리 함수 사이드메뉴 없음_____");
                    			this.sideHasNotProdAddToCart(row);
                    			
                    		}else{ // 사이드 메뉴가 있을 때 상품에 대한 셋팅.
                    			util.logInfo("_____컵 보증금 선택 후처리 함수 사이드메뉴 있음_____");
                    			//중복체크
    							/************************************************************
    							 *  중복체크
    							 * 1. 사이드메뉴가 아니라면 다음 데이터를 비교
    							 * 2. 동일제품이 있다면 기존것에 1증가.
    							 * 3. 동일제품이 없다면 orderList 에 추가.(push)
    							 ************************************************************/
    							let flag = false;
    							let targetObj = null;
                        		for ( let i = 0 ; i < this.orderList.length ; i++ ) {
                        			let x5 = this.orderList[i];
                        			//사이드메뉴가 있는것만 비교한다.
                        			if ( x5.SIDE_MENU_YN == 'N') {
                        				continue;
                        			}

                        			if ( x5['사이드_중복체크값'] == row['사이드_중복체크값']) {
                        				
                        				// 기존에 선택한 데이터들 중에 cupList가 존재하지 않고(컵종류 없음) 선택한 상품도 cup종류가 없다면 같은 상품이므로 해당상품개수 plus수행
                        				if(!x5.cupList && !row.CUP_TYPE){ 
                        					flag = true;
                            				x5.ORDER_QTY++;
                            				targetObj = x5;
                            				util.logInfo('같은게 있어?' +  x5['사이드_중복체크값'] + ' > '+ row['사이드_중복체크값'] );                      					
                        				}else if(x5.cupList && row.CUP_TYPE){ // 기존에 선택했던 상품중에 cupList가 존재하고 해당상품에도 컵종류가 존재한다면 같은 컵종류인지 수행 
                        					for(var j=0; j<x5.cupList.length; j++){
                        						if(x5.cupList[j].CUP_TYPE == row.CUP_TYPE){ // 같은 상품이면서 컵종류가 같은게 존재할 때 해당 row의 상품 개수 plus 수행
                        							flag = true;
                                    				x5.ORDER_QTY++;
                                    				targetObj = x5;
                                    				util.logInfo('같은게 있어?' +  x5['사이드_중복체크값'] + ' > '+ row['사이드_중복체크값'] );
                        						}
                        					}		
                        				}   
                        			}
                        		}
                        		
                        		
                    			if ( flag == true ) { // 사이드 메뉴가 같으면
	                    			this.calcQtyAmount(targetObj);
	
	                    		} else { // 사이드 메뉴가 다르면
									this.orderList.push(row);
									$("#index"+row.PROD_CD).addClass("active");
	                    		}
	                    		this.resetPayInfo();
                    		}
                    		
                    		var vsResult = util.fnCupDataMng(row, this.orderList, this.totalAmount, this.totalAmountView);
                    		if(vsResult){
                    			this.totalAmount = Number(this.totalAmount) + gCupUprc;
            					this.totalAmountView =  util.numberWithCommas(this.totalAmount);
                    		}
                    		
                    	}
                        , isAddOptionClass: function ( sideMenuYn ) {
                            if( sideMenuYn == 'Y' ) return true;
                            else false;
                        }
                        
                        , isAddOptionClassForBest: function ( menuType ) {
                        	var menuTypeClass = "";
                            if( menuType == "2" ) return menuTypeClass = "badgeClassB badgeBest" ;
                            if( menuType == "3" ) return menuTypeClass = "badgeClassB badgeNew" ;
                            if( menuType == "4" ) return menuTypeClass = "badgeClassB badgeSoldout" ;
                            if( menuType == "5" ) return menuTypeClass = "badgeClassB badgeSale" ;
                            return menuTypeClass;
                        }
                        
                        , isAddOptionClassForBig: function ( menuType, index, menuSideYn ) {
                        	var menuTypeClass = "";
                        	if(index < 2) {
                        		if(index == 0){
                        			if( menuType == "2" ){
                        				menuTypeClass = "big1 badgeClass badgeBest" ;
                        			}
                        			else if( menuType == "3" ){
                            			menuTypeClass = "big1 badgeClass badgeNew" ;
                            		}
                        			else if( menuType == "4" ){
                            			menuTypeClass = "big1 badgeClass badgeSoldout" ;
                            		}
                        			else if( menuType == "5" ){
                            			menuTypeClass = "big1 badgeClass badgeSale" ;
                            		}else{
                            			menuTypeClass = "big1" ;
                            		}
                        			
                        		}
                        		if(index == 1){
                        			if( menuType == "2" ){
                        				menuTypeClass = "big2 badgeClass badgeBest" ;
                        			}
                        			else if( menuType == "3" ){
                            			menuTypeClass = "big2 badgeClass badgeNew" ;
                            		}
                        			else if( menuType == "4" ){
                            			menuTypeClass = "big2 badgeClass badgeSoldout" ;
                            		}
                        			else if( menuType == "5" ){
                            			menuTypeClass = "big2 badgeClass badgeSale" ;
                            		}else{
                            			menuTypeClass = "big2" ;
                            		}
                        		}
                        	} else {
                        		if( menuType == "2" ) menuTypeClass = "badgeClass badgeBest" ;
                        		if( menuType == "3" ) menuTypeClass = "badgeClass badgeNew" ;
                        		if( menuType == "4" ) menuTypeClass = "badgeClass badgeSoldout" ;
                        		if( menuType == "5" ) menuTypeClass = "badgeClass badgeSale" ;
                        	}
                        	
                        	if(this.isAddOptionClass(menuSideYn)) menuTypeClass += " addOption";
                        		
                            return menuTypeClass;
                        }

                        , calcQtyAmount : function(row) {
                        	util.logDebug('calcQtyAmount :  금액산출.' ) ;
                        	
                        	if(!row['사이드_보증금포함_합계금액']){
								row['사이드_보증금포함_합계금액'] = 0;
							}
                        	if(!row['사이드_보증금포함_합계금액_출력용']){
								row['사이드_보증금포함_합계금액_출력용'] = 0;
							}
            				if(!row['CUP_DEPOSIT_UPRC_SUM']){
            					row['CUP_DEPOSIT_UPRC_SUM'] = 0;
            				}
                        	if ( row.SIDE_MENU_YN == 'N') {
                				row['합계금액']			= row['판매단가'] * row.ORDER_QTY  ;//합계금액으로 계산하기 위하여.
                				row['합계금액_출력용']	= util.numberWithCommas(row['합계금액']) ;//합계금액을 산출 후 보여줄 Text(사용은 됨)
                				row['사이드_보증금포함_합계금액'] = Number(row['CUP_DEPOSIT_UPRC_SUM']) + Number(row['합계금액']);
    							row['사이드_보증금포함_합계금액_출력용'] = util.numberWithCommas(row['사이드_보증금포함_합계금액']);
                        	} else {
                        		util.logDebug('사이드 계산 : ' , row);
    							row['사이드포함_합계금액']			= row['사이드포함판매단가'] * row.ORDER_QTY ;//합계금액으로 계산하기 위하여.
    							row['사이드포함_합계금액_출력용']	= util.numberWithCommas( row['사이드포함_합계금액'] ) ;//합계금액을 산출 후 보여줄 Text(사용은 됨)
    							row['사이드_보증금포함_합계금액'] = Number(row['CUP_DEPOSIT_UPRC_SUM'])+ Number(row['사이드포함_합계금액']);
    							row['사이드_보증금포함_합계금액_출력용'] = util.numberWithCommas(row['사이드_보증금포함_합계금액']);

                        	}
                        }

                        /**********************************************************
                         * 카트 상품에서 minus(-) 버튼 클릭.
                         **********************************************************/
                        , mainProdMinus : function( row , index, btnClickYn ) {
                        	util.logInfo( "( 메인 수량 차감 ) mainProdMinus Button click index : " + index + " => " + JSON.stringify(row));
                        	
                        	if(gSubsMenuHasChk == "Y" && row.MBS_PROD_YN == "Y") { // 구독권 구입상품이 있는경우에
                        		gSubsMenuHasChk = "N";
                        		
                        		//전체상품 클릭시 선택상품 수량변경 버튼 클릭 금지 off
                            	$(".quantity > *").attr("disabled", false);
                    		}
                        	
                        	row.ORDER_QTY--;//수량증가

                        	if ( row.ORDER_QTY == 0 ) {
                        		//수량이 0개 이면 초기화 한다.
                        		this.orderList.splice(index, 1);
                        		$("#index"+row.PROD_CD).removeClass("active");
                        	} else {

                        		this.calcQtyAmount(row);//수량+단가
                        	}
                        	
                        	if(btnClickYn == "Y"){
                        		var voCupList = row.cupList;
                        		if(!!voCupList){
                        			for(var i=0;i<voCupList.length;i++){
                        				var voCupRow = voCupList[i];
                        				voCupRow["CUP_CNT"] = Number(voCupRow["CUP_CNT"]) - 1;
                        				if(voCupRow["CUP_TYPE"] == "disposableCup"){
                        					voCupRow["CUP_AMT"] = Number(voCupRow["CUP_AMT"]) - gCupUprc;
                        					row['CUP_DEPOSIT_UPRC_SUM'] = Number(row['CUP_DEPOSIT_UPRC_SUM']) - gCupUprc; 
                        					row['사이드_보증금포함_합계금액'] =  Number(row['사이드_보증금포함_합계금액']) - gCupUprc;
                        					row['사이드_보증금포함_합계금액_출력용'] = util.numberWithCommas(row['사이드_보증금포함_합계금액']);
                        					this.totalAmount = Number(this.totalAmount) - gCupUprc;
                        					this.totalAmountView =  util.numberWithCommas(this.totalAmount);
                        				}
                        			}
                        		}
                        	}
                        	
                        	this.resetPayInfo();//금액 재산출 및 기타정보 재설정
                        }

                        /**********************************************************
                         * 카트 상품에서 plus(+) 버튼 클릭.
                         **********************************************************/
                        , mainProdPlus : function( row , index, btnClickYn ) {
//                        	if(gsSpecialShopFlag == "7" || gsSpecialShopFlag == "9"){ // 매장 판단 - 값이 7or9인 경우 알다방 매장, 레인보우 로보틱스  
//                        		var vnOrderQtySum = util.fnOrderQtySum(this.orderList); // 총 주문 수량이 3개 이하여야 한다.
//                        		if(vnOrderQtySum == 3){
//                        			let dataObj = {};
//                        			dataObj.button2Show = true;
//                        			dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
//                        			dataObj.message = util.languageObjReturn(langCode,  'threeQtyLimit');
//                        			eventBus.$emit('alertPopupIndex', dataObj);
//                        			return false;
//                        		}                        		
//                        	}
                        	//console.clear();

							// 셀프계산대 무인매장일때는 이벤트상품 스킵처리
							if(this.shopUntactType == '0' && this.indexBarcodeVal == '0'){ // 샵타입 기존매장, 셀프계산대 대기화면 바코드 인식 기능 둘다 미사용일시에만 체크
								if(row.TU_CLS_PROC_FG == '0'){ // 터치키분류 처리구분 0:단일선택 1:복수선택
									let dataObj = {};
									   dataObj.button2Show = true;
									   dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
									   dataObj.message = '1개의 수량만 선택가능합니다.'
									   eventBus.$emit('alertPopupIndex', dataObj);
									return false;
								}
							}

                        	util.logDebug( "(메인 수량 증가) mainProdPlus Button click index : " + index + " => " + JSON.stringify(row));
                        	if(gSubsMenuHasChk == "Y" && row.MBS_PROD_YN == "Y") { // 구독권 구입상품이 있는경우엔 수량 증가 X
                				return;
                    		}
                        	row.ORDER_QTY++;//수량증가
                        	util.logInfo("(메인 수량 증가) mainProdPlus Button click index 상품명 : "  + row.PROD_NM + ", 상품 가격 : " + row.판매단가_출력용 + ", 상품수량 증가 : " + row.ORDER_QTY);
                        	this.calcQtyAmount(row);//수량+단가
                        	this.resetPayInfo();//금액 재산출 및 기타정보 재설정
                        	if(btnClickYn == "Y"){
                        		var voCupList = row.cupList;
                        		if(!!voCupList){
                        			for(var i=0;i<voCupList.length;i++){
                        				var voCupRow = voCupList[i];
                        				voCupRow["CUP_CNT"] = Number(voCupRow["CUP_CNT"]) + 1;
                        				if(voCupRow["CUP_TYPE"] == "disposableCup"){
                        					voCupRow["CUP_AMT"] = Number(voCupRow["CUP_AMT"]) + gCupUprc;
                        					row['CUP_DEPOSIT_UPRC_SUM'] = Number(row['CUP_DEPOSIT_UPRC_SUM']) + gCupUprc; 
                        					row['사이드_보증금포함_합계금액'] =  Number(row['사이드_보증금포함_합계금액']) + gCupUprc;
                        					row['사이드_보증금포함_합계금액_출력용'] = util.numberWithCommas(row['사이드_보증금포함_합계금액']);
                        					this.totalAmount = Number(this.totalAmount) + gCupUprc;
                        					this.totalAmountView =  util.numberWithCommas(this.totalAmount);
                        				}
                        			}
                        		}
                        	}
                        }
                        /**********************************************************
                         * 카트 상품에서 사이드메뉴 minus(-) 버튼 클릭.
                         **********************************************************/
                        , mainProdMinusSide : function( row , index ) {
                        	util.logInfo( "( 메인 수량 차감 ) mainProdMinusSide Button click index : " + index + " => " + JSON.stringify(row));
                        	row.ORDER_QTY--;//수량증가
                        	util.logInfo("(메인 수량 차감) mainProdPlus Button click index 상품명 : "  + row.PROD_NM + ", 상품 가격 : " + row.판매단가_출력용 + ", 상품수량 차감 : " + row.ORDER_QTY);
                        	if ( row.ORDER_QTY == 0 ) {
                        		//수량이 0개 이면 초기화 한다.
                        		this.orderList.splice(index, 1);
                        	} else {

                        		this.calcQtyAmount(row);//수량+단가
                        	}
                        	this.resetPayInfo();//금액 재산출 및 기타정보 재설정
                        }

                        /**********************************************************
                         * 카트 상품에서 사이드메뉴 plus(+) 버튼 클릭.
                         **********************************************************/
                        , mainProdPlusSide : function( row , index ) {
                        	//console.clear();
                        	util.loInfo( "(메인 수량 증가) mainProdPlusSide Button click index : " + index + " => " + JSON.stringify(row));
                        	row.ORDER_QTY++;//수량증가
                        	this.calcQtyAmount(row);//수량+단가
                        	this.resetPayInfo();//금액 재산출 및 기타정보 재설정
                        }

                        , sideVariableInit : function() {
                        	util.logInfo("SIDE 정보 초기화.");
                        	this.prodSide    = [];
                			this.sideGrpList = [];
                			this.sideList    = [];

                        }

                        , cartAllClearProcess : function (mode) {
                        	if (mode == 'CANCEL') {
                        		return;
                        	}

                        	if ( mode == 'OK' ) {
                        		this.orderList   = [];
                        		this.sideVariableInit();

                        		this.resetPayInfo();//금액 재산출 및 기타정보 재설정
                        		gSubsMenuHasChk = "N";
                        		
                        		//전체상품 클릭시 선택상품 수량변경 버튼 클릭 금지 off
                            	$(".quantity > *").attr("disabled", false);
                        		return;
                        	}
                        }
                        // 상품전체삭제
                        , cartItemAllDeleteBtnClick : function () {
                        	//카트에 담긴 것이 있다면 적용.
                        	if ( !util.isEmpty(this.orderList) && this.orderList.length != 0 ) {
                        		var obj = { message : util.languageObjReturn(langCode, 'orderInitConfirmMessage'), messageType : "confirm" };
                        		this.$root.$emit("notiMessage" , obj );
                        		$('#noti_message').html("<p>"+obj.message+"</p>");
                        	}
                        	util.logInfo("______________ (상품결제)전체 상품 취소 버튼 선택 _______________" )
                        }

                        /*******************************************************************************************************
                         * 주문상품에 변동이 있을때 다시 적용되는 부분(금액, 결제 가능 버튼)
                         *******************************************************************************************************/
                        , resetPayInfo : function () {
                        	util.logInfo("_________ resetPayInfo(order.menu.list) 시작___________");
                        	this.POS_ODHDR_T = {};
                        	if ( this.orderList.length == 0 ) {
                        		this.isPayAbleBtn = false;//결제 가능으로 처리.
                        		this.totalAmountView = "0";
                        		this.totalAmount = 0 ;
                        		this.totalProdCnt = 0;
                        		this.totalProdCntView = "0";
                        	} else {
                        		let TOT_SALE_AMT    = 0; //총매출액
                        		let VAT_SALE_AMT    = 0; //과세매출액 합계
                        		let VAT_AMT         = 0; //VAT 총액;
                        		let NO_VAT_SALE_AMT = 0; //면세매출액
                        		let NO_TOT_SALE_AMT = 0; //과세 별도일 때 과세금액제외 총매출액(과세포함일때는 사용x)
                        		let CUP_DEPOSIT_UPRC_SUM = 0; // 컵보증금의 금액의 합
                        		let TOT_SALE_UPRC_ORG = 0; //총판매금액기준 합계
                        		//let TOT_SALE_UPRC_ORG_CB = 0; //총판매금액기준 합계-커반전용(구독권)
                        		this.isPayAbleBtn = true;//결제 가능으로 처리.
                        		this.totalProdCnt = 0;
                        		this.totalProdCntView = "0";
                        		
                        		for ( let i = 0 ; i < this.orderList.length ; i++ ) {
                        			let x5  = this.orderList[i];                        			
                        			if(!util.isEmpty(x5)) {
                        				if ( x5.SIDE_MENU_YN == 'N') {
                        					this.totalProdCnt += parseInt(x5.ORDER_QTY);
                        					
                        					TOT_SALE_AMT += x5.합계금액;
                        					x5['공급가_총_합계']	= Number(x5['공급가']) * x5.ORDER_QTY;
                        					x5['VAT_총_합계']		= Number(x5['VAT'   ]) * x5.ORDER_QTY;
                        					
                        					VAT_SALE_AMT += x5['공급가_총_합계'];
                        					VAT_AMT      += x5['VAT_총_합계'   ];
                        					
                        					//실판매금액합계 
                        					TOT_SALE_UPRC_ORG += parseInt(x5.SALE_UPRC_ORG) * x5.ORDER_QTY;
                        					//할인안된 판매가 합계 커반 구독권 전용
//                        					if(x5.NORMAL_UPRC_ORG === undefined ) {
//                        						TOT_SALE_UPRC_ORG_CB += parseInt(x5.NORMAL_UPRC) * x5.ORDER_QTY;
//                        					} else {
//                        						TOT_SALE_UPRC_ORG_CB += parseInt(x5.NORMAL_UPRC_ORG) * x5.ORDER_QTY;
//                        					}
                        					
                        					util.logInfo("(No Opt)상품명 :  " + x5.PROD_NM + "  >  수량 : " + x5.ORDER_QTY + " > 판매단가 : " + x5.판매단가 + "> 합계금액 : " + x5.합계금액
                        							+  "( 검증금액) " + ( x5.판매단가 *x5.ORDER_QTY)
                        							+ "검증결과 : "+ ( ( x5.판매단가 *x5.ORDER_QTY) == x5.합계금액)
                        					);
                        					
                        				} else {
                        					this.totalProdCnt += x5.ORDER_QTY;
                        					TOT_SALE_AMT += x5.사이드포함_합계금액 ;
                        					x5['사이드_포함_공급가_총_합계']= x5.사이드_포함_공급가_합계 * x5.ORDER_QTY;
                        					x5['사이드_포함_VAT_총_합계'   ]= x5.사이드_포함_VAT_합계    * x5.ORDER_QTY;
                        					
                        					VAT_SALE_AMT += x5['사이드_포함_공급가_총_합계'];
                        					VAT_AMT      += x5['사이드_포함_VAT_총_합계'   ];
                        					
                        					//실판매금액합계 
                        					TOT_SALE_UPRC_ORG += parseInt(x5.SALE_UPRC_ORG) * x5.ORDER_QTY;
                        					//할인안된 판매가 합계 커반 구독권 전용
//                        					if(x5.NORMAL_UPRC_ORG === undefined ) {
//                        						TOT_SALE_UPRC_ORG_CB += parseInt(x5.NORMAL_UPRC) * x5.ORDER_QTY;
//                        					} else {
//                        						TOT_SALE_UPRC_ORG_CB += parseInt(x5.NORMAL_UPRC_ORG) * x5.ORDER_QTY;
//                        					}
                        					
                        					util.logInfo(
                        							"(Yes Opt)상품명 :  " + x5.PROD_NM
                        							+ "  >  수량 : " + x5.ORDER_QTY
                        							+ " > 사이드포함판매단가 : " + x5.사이드포함판매단가
                        							+ " > 합계금액 : " + x5.사이드포함_합계금액
                        							+ " ( 검증금액) " + ( x5.사이드포함판매단가 *x5.ORDER_QTY)
                        							+ " 검증결과 : " + (  ( x5.사이드포함판매단가 *x5.ORDER_QTY) == x5.사이드포함_합계금액)
                        					);
                        					
                        				}
                        				
                        			}
                        			CUP_DEPOSIT_UPRC_SUM += Number(x5.CUP_DEPOSIT_UPRC_SUM);
                        			
                        		}
                        		//NO_VAT_SALE_AMT = TOT_SALE_AMT - VAT_SALE_AMT - VAT_AMT;
                        		NO_TOT_SALE_AMT = TOT_SALE_AMT - VAT_AMT;
                        		this.POS_ODHDR_T =  {
                        				  TOT_SALE_AMT    : TOT_SALE_AMT
                        				//, VAT_SALE_AMT    : VAT_SALE_AMT
                        				, VAT_AMT         : VAT_AMT
                        				//, NO_VAT_SALE_AMT : NO_VAT_SALE_AMT
                        				, NO_TOT_SALE_AMT : NO_TOT_SALE_AMT
                        				, TOT_SALE_UPRC_ORG : TOT_SALE_UPRC_ORG
                        				//, TOT_SALE_UPRC_ORG_CB : TOT_SALE_UPRC_ORG_CB
                        		}
//                        		this.totalAmount = TOT_SALE_AMT ;
                        		this.totalAmount = TOT_SALE_AMT + CUP_DEPOSIT_UPRC_SUM; // 1회용 보증금컵 더하는 로직 추가됨.
                        		this.totalAmountView = util.numberWithCommas(this.totalAmount);
                        		this.totalProdCntView = util.numberWithCommas(this.totalProdCnt);
							}
                        	util.logInfo("_________ resetPayInfo(order.menu.list) 끝___________");
                        }
                        , fnClickNotifyTaklPopup : function(){

                            util.logInfo( "fnClickNotifyTaklPopup notifyTalkInterlock : " + notifyTalkInterlock);

                            if(notifyTalkInterlock == "1" || notifyTalkInterlock == "2"){
                                this.$root.$emit('notifyTalkConfirmPopup', {"id" : this.$route.params.id});
                            }
                        }
                        
                        , click_paymentChoiceBtn : function() {
                        	gsOrderNo="";
                        	//메인포스에서 주문번호를 받아오는 경우에는 db저장전에 한번더  채번을 해준다. 중복금지!!
                        	util.getOrderNoAsp(this.paymentChoiceCallback);
                        }
                        /**************************************************
                         * PAY 버튼 클릭시 처리(결제)
                         **************************************************/
                        , paymentChoiceCallback : function(result) {
                        	util.logInfo("______________ (상품결제)결제 버튼 선택 _______________" );
                        	
							util.logInfo("______gReRegFlag_____ 초기화.. ");
							gReRegFlag = "N";

                        	var vbAspOrderNoSuccessYn = result;
                    		if(!vbAspOrderNoSuccessYn){
                    			this.fnAspOrderNoFailMsg();
                    			return false;
                    		}
                    		
                        	//결제버튼 클릭시 선택상품 수량변경 버튼 클릭 금지
                        	$(".quantity > *").attr("disabled", true);
                        	//$("div[id^='index']").attr("disabled", true);
                        	
                        	if(gsSpecialShopFlag == "5") { // 매장 판단 - 값이 5인 경우 커반 매장(이퀴닉스 서버로 전송할지 여부판단),
                        		var deviceCheckResult = "";
                        		deviceCheckResult = util.ajaxCallKerbanDeviceCheck();
                        		if(deviceCheckResult != "true") {
                        			let dataObj2 = {};
                        			dataObj2.button2Show = true;
                        			dataObj2.button2Func = this.goToMainPage
                        			dataObj2.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
        							if(deviceCheckResult == "false"){
        								dataObj2.message = util.languageObjReturn(langCode,  'kerbanDeviceFalse');
        							} else {
        								dataObj2.message = util.languageObjReturn(langCode,  'kerbanDeviceError');
        							}
            						eventBus.$emit('alertPopupIndex', dataObj2);
                        			return;
                        		}                        	
                        	} else if(gsSpecialShopFlag == "7" || gsSpecialShopFlag == "9") { // 알다방인 경우 or 레인보우 로보틱스                    		
                        		var vsParam = {"MSG_TYPE":"REQ_STATUS"};
                        		// 1분마다 상태체크 시작.
                    			var result = util.ajaxCallJson(vsParam, gAldabangUrl, false);
                    			util.logInfo("_____알다방 상태체크 결과 값(setInterval) == >> " + JSON.stringify(result));
                        		if(result == "error" || result == "timeout"){
                        			alert("기기상태 체크가 원활하지 않습니다. 통신 상태를 확인해주세요.");
                        			return;
                        		}         		
                        		if(!result.READY){ // 준비 상태가 false라면 점검중 화면으로 이동.
                        			let dataObj2 = {};
                        			dataObj2.button2Show = true;
                        			dataObj2.button2Func = this.goToMainPage
                        			dataObj2.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
       								dataObj2.message = util.languageObjReturn(langCode,  'kerbanDeviceFalse'); // "바리스타가 머신을 점검중입니다. 잠시 후 재시도 해주세요.";
            						eventBus.$emit('alertPopupIndex', dataObj2);
                        			return;
                        		}
                        	}
                        	
                        	orderInfo = {};
                        	// 결제 버튼 눌렀을 때 보증금의 총 합계를 계산하여 pos_odhdr_t의 컬럼에 넣어준다.
                        	var vsCnt = this.orderList.length;
                        	var vnCupAmt = 0;
                        	var vnCupCnt = 0;
                        	for(var i=0;i<vsCnt;i++) { // 주문내역만큼 for문
                        		var voOrderList = this.orderList[i]; 
                        		if(!!voOrderList.cupList){ // 컵객체가 존재하면
                        			for(var j=0;j<voOrderList.cupList.length;j++){ // 컵 객체의 row수만큼 for문
                        				if(voOrderList.cupList[j].CUP_TYPE == "disposableCup"){ // 1회용 보증금 컵이라면
                        					vnCupAmt += Number(voOrderList.cupList[j].CUP_AMT); // 해당 row의 보증금컵 금액을 합산한다.
                        				}
                        			}
                        		}
                        		
                        		if(!!voOrderList.ORDER_QTY){
                        			vnCupCnt += Number(voOrderList.ORDER_QTY);
                        		}
                        	}         
                        	
                        	if(!util.isEmpty(gBarodaInfo)) {
                        		//톨게이트 일일 할인 구매 수량보다 큰 경우에는 결제 X -> 메인으로 이동 
                        		if(Number(gBarodaInfo.avaliableQuantity) < vnCupCnt) {
                        			let dataObj = {};
                        			dataObj.button2Show = true;
        							dataObj.button2Func = this.goToMainPage
        							dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
                            		dataObj.message = util.languageObjReturn(langCode,  'failTollgateOrderPayment');
            						eventBus.$emit('alertPopupIndex', dataObj);
                        			return;
                        		}
                        	}
                        	
                        	this.POS_ODHDR_T["CUP_DEPOSIT_AMT"] = vnCupAmt; // 컵보증금의 함계를 헤더에 넣어준다.
                        	
                        	orderInfo.POS_ODHDR_T = this.POS_ODHDR_T;
                        	orderInfo.POS_ODDTL_T = this.orderList ;
                        	orderInfo.POS_ODHDR_T.KITCHEN_MEMO		= this.KITCHEN_MEMO ;  // - KITCHEN_MEMO(string)   : 수령방법( takeout | eat )
                        	
                        	
                        	if(isNaN(orderInfo.POS_ODHDR_T.TOT_SALE_AMT)) {
                    			let dataObj = {};
                    			dataObj.button2Show = true;
    							dataObj.button2Func = this.goToMainPage
    							dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
                        		dataObj.message = util.languageObjReturn(langCode,  'failOrderPayment');
        						eventBus.$emit('alertPopupIndex', dataObj);
                    			return;
                    		}
                        	
                        	/**********************************************************
                        	 * 사이드 메뉴에 따라 달리 금액계산
                        	 * SALE_AMT
                        	 * DCM_SALE_AMT
                        	 * VAT_AMT
                        	 * 과세대상금액
                        	 * 비과세대상금액
                        	 **********************************************************/
                        	let TAX_SALE_AMT = 0 , NON_TAX_SALE_AMT = 0;
                        	let SDS_ORG_DTL_NO_CNT = 0;//side 의 그룹번호 지정.
                        	
                        	let cornerObj = {};

                        	let totalDcAmt = 0;
                        	let totalDcAmtForBaroda = 0;
                        	let totalAmount = 0;
                        	let amount = 0;
                        	let discountAmount = 0;
							let dcPackAmt = 0;
                        	
                        	util.logInfo("orderInfo.POS_ODDTL_T.length : " + orderInfo.POS_ODDTL_T.length);
                        	
                        	orderInfo.POS_ODDTL_T.forEach(e => {
                        		if(!util.isEmpty(e)) {
                        			if ( e.SIDE_MENU_YN == 'Y') {
                        				e.VAT_AMT      = parseInt( e.사이드_포함_VAT_총_합계      );
                        				e.SALE_AMT     = parseInt( e.사이드포함_합계금액 ); //SALE_AMT     : 매출액
                        				e.DCM_SALE_AMT = parseInt( e.사이드포함_합계금액 ); //DCM_SALE_AMT : 실매출액
                        				
//                        			if(SHOP_INFO.VAT_CD == "0") {
//                        				e.SALE_AMT     = e.SALE_AMT - e.VAT_AMT; //SALE_AMT     : 매출액
//                            			e.DCM_SALE_AMT = e.DCM_SALE_AMT - e.VAT_AMT; //DCM_SALE_AMT : 실매출액
//                        			} 
                        				
                        				/**************** SIDE 가 있을 경우 SDS_ORG_DTL_NO 넣기 Start .***************************/
                        				let sl = e.사이드_LIST  ;
                        				e.SDS_ORG_DTL_NO =  ++ SDS_ORG_DTL_NO_CNT;//채번은 1번부터 한다.
                        				sl.forEach( x => {
                        					x.SDS_ORG_DTL_NO =  SDS_ORG_DTL_NO_CNT;
                        				});
                        				/**************** SIDE 가 있을 경우 SDS_ORG_DTL_NO 넣기 End   .***************************/
                        				
                        			} else {
                        				e.VAT_AMT      = parseInt( e.VAT      );
                        				e.VAT_AMT      = parseInt( e.VAT_총_합계      );
                        				e.SALE_AMT     = parseInt( e.합계금액 ); //SALE_AMT     : 매출액
                        				e.DCM_SALE_AMT = parseInt( e.합계금액 ); //DCM_SALE_AMT : 실매출액
                        				
//                        			if(SHOP_INFO.VAT_CD == "0") {
//                        				e.SALE_AMT     = e.SALE_AMT - e.VAT_AMT; //SALE_AMT     : 매출액
//                            			e.DCM_SALE_AMT = e.DCM_SALE_AMT - e.VAT_AMT; //DCM_SALE_AMT : 실매출액
//                        			} 
                        				
                        			}
                        			
                        			var togoChargeTemp = 0;
                        			
                        			//포장할인 상품을 결제할때 과세대상금액에서 할인금액을 빼고 계산해준다
                        			//먹고가기 상품이 아니면서 핧인금액이 있는경우 결제상품별로 할인금액을 계산
                        			if(gvEatTakeOutVal == "0" || gvEatTakeOutVal == "1" || gvEatTakeOutVal == "2"){
                        				if(gOrderType == "takeout"){
                        					if(e.TOGO_CHARGE !== undefined && e.TOGO_PROD_YN !== undefined) {
                        						if(e.TOGO_PROD_YN != "N" && e.TOGO_CHARGE < 0){
                        							togoChargeTemp = Math.abs(e.TOGO_CHARGE) * e.ORDER_QTY;
                        							e.DC_AMT_PACK = togoChargeTemp;
                        							// e.DC_AMT = e.DC_AMT_PACK;                        							
//                        							if(SHOP_INFO.VAT_CD == "1") {
//                        								e.DCM_SALE_AMT = e.DCM_SALE_AMT - e.DC_AMT_PACK;
//                        							}
													dcPackAmt += togoChargeTemp;
                        						}
                        					} 
                        				}
                        			}
                        			
                        			if( e.TAX_YN == 'Y')  {
                        				TAX_SALE_AMT += e.SALE_AMT - e.VAT_AMT;
                        				if(SHOP_INFO.VAT_CD == "0") { //미포함 세금별도
                        					//TAX_SALE_AMT += e.SALE_AMT - togoChargeTemp;
                        					this.calcByCornerData ( cornerObj , e      , e.SALE_AMT, e.VAT_AMT , e.SALE_AMT - e.VAT_AMT    , 0 );
                        				} else {  //포함 == 01
                        					//TAX_SALE_AMT += e.SALE_AMT - e.VAT_AMT - togoChargeTemp;
                        					this.calcByCornerData ( cornerObj , e      , e.SALE_AMT , e.VAT_AMT , e.SALE_AMT - e.VAT_AMT     , 0 );
                        				}
                        				
                        			} else {
                        				NON_TAX_SALE_AMT += e.SALE_AMT;
                        				this.calcByCornerData ( cornerObj , e      , e.SALE_AMT , e.VAT_AMT , 0 , e.SALE_AMT  );
                        			}
                        			
                        			if(!util.isEmpty(gBarodaInfo)) { //커반 구독할인권이 있는경우 할인금액을 표시해준다. 구독할인금액 계산!!
                        				let gBarodaDcAmtTemp = 0;
                        				
                        				// 결제화면에서 메뉴화면으로 돌아오면 기존 NORMAL_UPRC 금액이 판매금액으로 대체되기 때문에 
                        				// 할인 금액의 기준이 달라져서 임의의 변수에 원래 상품 가격을 저장
                        				gBarodaDcAmtTemp = (Number(e.NORMAL_UPRC) - Number(e.SALE_UPRC)) * e.ORDER_QTY;
                    					totalAmount += Number(e.NORMAL_UPRC) * e.ORDER_QTY;
                    					
//                        				if(Number(e.판매단가) < Number(e.NORMAL_UPRC)) {
//                        					gBarodaDcAmtTemp = (Number(e.NORMAL_UPRC) - Number(e.SALE_UPRC)) * e.ORDER_QTY;
//                        					totalAmount += Number(e.NORMAL_UPRC) * e.ORDER_QTY;
//                        					e.NORMAL_UPRC_ORG = e.NORMAL_UPRC;
//                        				} else {
//                        					gBarodaDcAmtTemp = (Number(e.NORMAL_UPRC_ORG) - Number(e.SALE_UPRC)) * e.ORDER_QTY;
//                        					totalAmount += Number(e.NORMAL_UPRC_ORG) * e.ORDER_QTY;
//                        				}
//                        				
                        				e.DC_AMT = gBarodaDcAmtTemp;
                        				totalDcAmtForBaroda += gBarodaDcAmtTemp;
                        				//원상품 금액, 실제 결제 금액, 구독권으로 인해 할인된 금액을 바로다쪽으로 전송추가 - 2023-03-29 추가
                        				//할인 금액(주문 총 금액에 구독권 할인을 통해 할인받은 금액)
                        				discountAmount += gBarodaDcAmtTemp;
                        				//총 상품 금액(주문 총 금액) - 할인전 상품금액 계산 
                        				//결제 금액(실 결제 금액) - 할인된 상품금액 계산 
                        				amount += Number(e.SALE_UPRC) * e.ORDER_QTY;
                        			}

									/*
									if(kerbanDiscountRateYn == 'Y'){ // 커반 할인률적용 여부

										var kerbanDiscountTemp = 0;
										// 결제화면에서 메뉴화면으로 돌아오면 기존 NORMAL_UPRC 금액이 판매금액으로 대체되기 때문에 
                        				// 할인 금액의 기준이 달라져서 임의의 변수에 원래 상품 가격을 저장
                        				kerbanDiscountTemp = (Number(e.NORMAL_UPRC) - Number(e.SALE_UPRC)) * e.ORDER_QTY;
                    					totalAmount += Number(e.NORMAL_UPRC) * e.ORDER_QTY;
                    					
                        				e.DC_AMT = kerbanDiscountTemp;
                        				totalDcAmt += kerbanDiscountTemp;
										
                        				//원상품 금액, 실제 결제 금액, 구독권으로 인해 할인된 금액을 바로다쪽으로 전송추가 - 2023-03-29 추가
                        				//할인 금액(주문 총 금액에 구독권 할인을 통해 할인받은 금액)
                        				discountAmount += gBarodaDcAmtTemp;
                        				//총 상품 금액(주문 총 금액) - 할인전 상품금액 계산 
                        				//결제 금액(실 결제 금액) - 할인된 상품금액 계산 
                        				amount += Number(e.SALE_UPRC) * e.ORDER_QTY;

									}
									*/
                        			
                        			if(SHOP_INFO.VAT_CD == "0") { // 부가세 별도.
                        				e.SALE_AMT     = e.SALE_AMT - e.VAT_AMT ; //SALE_AMT     : 매출액
                        				e.DCM_SALE_AMT = e.DCM_SALE_AMT - e.VAT_AMT; //DCM_SALE_AMT : 실매출액
                        				e.NORMAL_UPRC = e.판매단가 - e.VAT;
                        				e.SALE_UPRC = e.NORMAL_UPRC;
                        				//TAX_SALE_AMT += togoChargeTemp;                        			
                        			} else { // 부가세 포함.
                        				if(util.isEmpty(gBarodaInfo)) { 
                        					e.NORMAL_UPRC  = e.판매단가;
                        				} 
                        				// 사이드리스트의 SIDE_SALE_UPRC에 부가세를 더해준다. ( 해당 컬럼은 부가세 여부에 따
                        				if(e.사이드_LIST != undefined){
                        					for(var i=0; i<e.사이드_LIST.length; i++){
                        						if(e.사이드_LIST[i].공급가 != undefined && e.사이드_LIST[i].공급가 != "0" ){
                        							e.사이드_LIST[i].SIDE_SALE_UPRC = Number(e.사이드_LIST[i].SIDE_SALE_UPRC) + ( Number(e.사이드_LIST[i].VAT) / Number(e.사이드_LIST[i].SIDE_QTY) )
                        						}
                        					}
                        				}
                        				
                        			}
                        		}
                        		
                        		//구독서비스 제품이 있는 경우
                        		if(e.MBS_PROD_YN == "Y"){
                        			orderInfo.mbsProdYn = "Y";
                        			// 구독권 금액, 주문번호 추가 2023-03-29
                        			let BARODA_INFO = {
                    					subscribeProductCode : e.PROD_CD
                    					, subscribeProductName : e.PROD_NM
                    					, amount : e.SALE_UPRC
                            		}
                        			orderInfo.BARODA_INFO = BARODA_INFO;
                        		}
                        		
                			});

                        	//총 포장할인 금액
                    		orderInfo.POS_ODHDR_T.DC_PACK_AMT = dcPackAmt;
                    		//총 할인금액 금액(제휴할인등 중복할인이 발생할 수 있음)
                    		orderInfo.POS_ODHDR_T.TOT_DC_AMT = totalDcAmt + totalDcAmtForBaroda + dcPackAmt;

							if(dcPackAmt > 0){
								orderInfo.POS_ODHDR_T.TOT_SALE_AMT = orderInfo.POS_ODHDR_T.TOT_SALE_AMT + dcPackAmt;
							}
                    		
                    		if(SHOP_INFO.VAT_CD == "0") {
                    			orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.NO_TOT_SALE_AMT;
                    		} else {
                    			//실매출금액 = 총 매출액 - 할인금액
                    			orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.TOT_SALE_AMT - orderInfo.POS_ODHDR_T.DC_PACK_AMT;
                    		}

							// TAX
							if(gsSpecialShopFlag != "5"){ // 커반매장이 아닌결우
								TAX_SALE_AMT = TAX_SALE_AMT - orderInfo.POS_ODHDR_T.TOT_DC_AMT + dcPackAmt;
							}
							// NON_TAX_SALE_AMT = NON_TAX_SALE_AMT - orderInfo.POS_ODHDR_T.TOT_DC_AMT;
							orderInfo.POS_ODHDR_T.TAX_SALE_AMT = TAX_SALE_AMT;
                        	orderInfo.POS_ODHDR_T.VAT_SALE_AMT = TAX_SALE_AMT;
                        	orderInfo.POS_ODHDR_T.NON_TAX_SALE_AMT = NON_TAX_SALE_AMT;
                        	orderInfo.POS_ODHDR_T.NO_VAT_SALE_AMT  = NON_TAX_SALE_AMT;
                        	orderInfo.POS_ODHDR_T.NO_TAX_SALE_AMT  = TAX_SALE_AMT + NON_TAX_SALE_AMT;
                    		
                        	if ( util.isEmpty( this.POS_ODHDR_T )) {
                        		return;
                        	}

                        	orderInfo.CORNER_LIST = [];
                        	for(k in cornerObj) {
                        		if ( k.indexOf("_DATA") == -1 )
                        			orderInfo.CORNER_LIST.push(  cornerObj[k + '_DATA']);
                        	}
                        	orderInfo.CORNER_OBJ = cornerObj;
                        	
                        	//할인금액이 결제금액보다 큰 경우에 결제X
                        	if ( orderInfo.POS_ODHDR_T.DCM_SALE_AMT <= 0) {
                        		var obj = { message : "", messageType : "alert" };
                        		var msg = util.languageObjReturn(langCode,  'cantPayLess');
                        		obj.message = msg;		 
                        		util.logInfo( "cantPayLess msg : " + msg);
								this.$root.$emit( "notiMessage" ,   obj  );
								$('#noti_message').html("<p>"+obj.message+"</p>");
                        		return;
                        	}
                        	
                        	//orderNo 채번
                        	this.getOrderNo();
                        	
                        	util.logInfo("______________ (상품결제) 결제버튼 눌렀을 때 결제수단선택 전환 전 객체 === >> " + JSON.stringify(orderInfo));
                        	
                        	if(!util.isEmpty(gBarodaInfo)) { //구독권 회원정보가 있는경우
                        		gBarodaInfo.totalAmount = totalAmount;
                        		gBarodaInfo.amount = amount;
                        		gBarodaInfo.discountAmount = discountAmount;
                        		orderInfo.BARODA_INFO = gBarodaInfo;
                        		orderInfo.POS_ODHDR_T.TOT_SALE_UPRC_ORG_CB = totalAmount;
                        	}
                        	
                        	//결제버튼 클릭시 상품클릭 방지
                        	this.preventClickProd = "Y";
                        	
                        	//구독서비스 제품이 있는경우 회원가입에 필요한 핸드폰 번호 입력화면으로 이동
                        	if(!util.isEmpty(orderInfo.mbsProdYn)){ 
                        		if(orderInfo.mbsProdYn == "Y"){
                        			router.push({"name": 'memberService', params: { id: gMealTake }})
                        		}
                        	} else {
                        		router.push({path: '/paymentChoiceView'});
                        	}
                        }
                        , fnAspOrderNoFailMsg: function() {
                        	util.logInfo("*****order.menu.list.js orderNoAsp fail message Start*****");
                    		var dataObj = {
      							  button1Show : false
      							, button1Name : util.languageObjReturn(langCode, 'no') // [ 아니오 ]
      							, button1Func : ""
      							, button2Show : true
      							, button2Name : util.languageObjReturn(langCode, 'noticeConfirm')// [ 확인 ]
      							, button2Func : ""
      							, message     : "메인포스와 통신이 원할하지 않습니다.\n확인 후 다시 시도해주세요.\n[Contact the administrator]"
      						};
                    		eventBus.$emit('alertPopupIndex', dataObj);
                        }
                        
                        , calcByCornerData : function (obj , e , saleAmt , vatAmt ,  taxSaleAmt , nonTaxSaleAmt){                        	
                        	/***********************************
                        	 * CORNER_CD          (코너정보)
                        	 * VAN_TERM_NO        (CAT_ID)
                        	 * SALE_AMT           (판매금액)
                        	 * TAX                (부가세 )
                        	 * NO_TAX_SALE_AMT    (면세대상금액)
                        	 * TAX_SALE_AMT       (과세대상금액)
                        	 ***********************************/
                        	var vsSqlResult = "";
                        	// 코너사업자의 명칭을 찾아와서 객체에 담는다. (결제 진행중에 코너사업자명을 명시하기 위해)
                        	if(e.CORNER_CD == "00"){
                        		vsSqlResult = gfn_SQLiteSQLProcess(sqlQuery.sqlSelectCornerNm00, [ gShopCd]).Data ;
                        	}else{
                        		vsSqlResult = gfn_SQLiteSQLProcess(sqlQuery.sqlSelectCornerNmEtc, [ gShopCd, e.CORNER_CD]).Data ;
                        	}            				

                        	if( obj[e.CORNER_CD] == undefined  ) {
                        		obj[e.CORNER_CD] = e.CORNER_CD;
                        		obj[e.CORNER_CD + '_DATA'] = {
                        				  CORNER_CD       : e.CORNER_CD
                        				, CORNER_NM       : vsSqlResult[0].CORNER_NM
                        				, VAN_TERM_NO     : e.VAN_TERM_NO
                        				, SALE_AMT        : 0
                        				, TAX             : 0
                        				, NO_TAX_SALE_AMT : 0
                        				, TAX_SALE_AMT    : 0
                        				, CUP_DEPOSIT_UPRC_SUM : 0
                        		}	
                        	}

                        	let o = obj[e.CORNER_CD + '_DATA'];
                        	o.SALE_AMT        += saleAmt          ;  //(판매금액)
                        	o.TAX             += vatAmt           ;  //(부가세 )
                        	o.NO_TAX_SALE_AMT += nonTaxSaleAmt    ;  //(면세대상금액)
                        	o.TAX_SALE_AMT    += taxSaleAmt       ;  //(과세대상금액)
                        	
                        	if(!util.isEmpty(e.CUP_DEPOSIT_UPRC_SUM)){
                        		o.CUP_DEPOSIT_UPRC_SUM += Number(e.CUP_DEPOSIT_UPRC_SUM) ;  //(과세대상금액)
                        	} 
                        }
                        ,
                        /********************************************************
                         * 상품 리스트 내부에 스타일 적용.
                         ********************************************************/
                        applyCssStyle : function () {
                    		$('.sideBtn').off('click');//기존 버튼 바인딩 된거 제거
                    		
                    		$(".quantity > *").attr("disabled", false);
            				/*//[추가] 2020-09-25::선택된 메뉴리스트 스크롤바 플러그인 적용*/
        					//[추가] 2020-09-25::스크롤 플러그인 호출(처음 스크롤이 없는 경우에 재호출 필요)
                    		let jsp   = $("#app  section.selectedMenu > div.menuList  div.jspPane");
                    		let slide = $("#app  section.selectedMenu > div.menuList  div.swiper-wrapper > div.swiper-slide");

                    		//element 를 강제 이동시킨다.jspPane 와 동급으로 element 가 추가되어서 swiper-slide element 를 강제이동시킨다.
                    		if ( jsp.length != 0 ) {
                    			if ( slide.length != 0 ) {
                    				slide.each(function( e , item ) {
                    					$(item).detach().appendTo(jsp) ;
                    				});
                    			}
                    		}
                    		
                    		//var $listItem = $('#app section.selectedMenu > div.menuList > div.selectedWrap > div.item');
                            //var listItemCount = $listItem.length;
                            //console.log(listItemCount)
                            
//                            if(this.orderList == 0){
//                            	var element = $(".orderListWrap .selectedMenu .menuList").jScrollPane();
//                            	var api = element.data('jsp');
//                            	api.destroy();
//                            }
                            
                    		let callCount = 0;/** jScrollPane 호출이 되지 않았을 경우 강제 호출하여야 한다. side 가 선태되지 않았을 경우 해당 부분 작동하지 않는다. **/


            				//토글버튼
            				$('.sideBtn').on('click',function(){
            					let sideNum = ($(this).parent().find('.menu').length);
            					let orgH = $('.selectedWrap .swiper-wrapper').height();
            					let varH = (sideNum * 85); //가변되는 높이
            					if($(this).attr('data-click-state') == 1) {
            						$(this).attr('data-click-state', 0);
            						$(this).parent().addClass('on');
            					} else {
            						$(this).attr('data-click-state', 1);
            						$(this).parent().removeClass('on');
            					}

            					callCount ++;
            					
        						//[추가] 2020-09-25::스크롤 플러그인 호출(처음 스크롤이 없는 경우에 재호출 필요)
        						$(".selectedMenu .selectedWrap .swiper-wrapper").jScrollPane({
        							showArrows: true,
        							horizontalGutter: 30,
        							verticalGutter: 30
        						});
	            				
            				});// .sideBtn on 이벤트. end

            				if(this.orderList !== undefined) {
            					//jScrollPane 호출되지는 않았지만 선택물품이 있을경우 scroll 생성해줘야 한다.
            					if ( callCount == 0 && this.orderList.length != 0 ) {
            						if(this.shopUntactType != "0") {
            							$(".selectedMenu .menuList").jScrollPane(
            									{
            										showArrows: true,
            										horizontalGutter: 30,
            										verticalGutter: 30
            									}
            							);
            							//console.log($sTarget.height())
            							/*//[수정] 2020-10-27::함수내용 수정*/
            							
            						} else {
            							$(".selectedMenu .selectedWrap .swiper-wrapper").jScrollPane({
            								showArrows: true,
            								horizontalGutter: 30,
            								verticalGutter: 30
            							});
            						}
            						
            						// 2020-12-30 백종기 추가. 메뉴리스트에 스크롤이 생길 때 메뉴명이 잘리는 문제로, 스크롤 영역이 생겼을 때 메뉴명width를 줄이고, 없을 때 다시 늘리도록 수정.
            						if($(".jspVerticalBar").length == 0){ // 스크롤 바가 없을 때
            							$(".selectedMenu .selectedWrap .menu .nameShot").attr("class", "name");
            						}else{ // 스크롤바가 있을 때
            							$(".selectedMenu .selectedWrap .menu .name").attr("class", "nameShot");
            						}
            						
            					}
            				}

                            //개발참고사항 :: 메뉴 스타일 적용
            				$('.food_list .item').off();//2020.11.05 기존이벤트 제거.

            				//데이터가 새로 들어오기 때문에 이벤트를 재적용한다.
                            $('.food_list .item').click(function(){
                            	$('.food_list .item').removeClass('on'); //[추가] 2020-06-12
                            	if ($(this).attr('stock') != '4') {
                            		$(this).addClass('on');
                            	}

							});

                        },
                        menuFontChange : function(){
                        	// 베스트 메뉴가 아닐 때만 적용한다. this.topMenuListType 조건 추가
                        	if(this.menuFontSmallFlag=="Y" && this.topMenuListType != "layout select_menu select_menu_horizontal"){ // 중메뉴 클릭하는 함수에서 Y로 변경됨
    							var vsMenuSmallYn = "N"; // 3라인 짜리가 존재하면 Y로 변경하여 폰트를 변경하기 위한 플래그
    							if(this.menuFontClass == "nameSmall"){ // 현재 폰트가 작은 class로 적용되어있을 때    								
    								$(".menuArea .food_list .item .nameSmall").attr("class", "name");
    							}    							    							
    							var vsMenuCnt = $(".menuArea .food_list .item .name").length;
    	                		for(var f=0; f<vsMenuCnt; f++){ // 메뉴명 개수만큼 포문
    	                			if($(".menuArea .food_list .item .name")[f].scrollHeight > "61"){ // 메뉴명이 61이 넘으면 (61은 두라인 일때  height)
    	                				vsMenuSmallYn = "Y";
    	                				break;
    	                			}
    	                		}
    	                		if(vsMenuSmallYn=="Y"){ // 61이 넘는 height가 존재한다면 폰트를 줄인다.(18px)
    	                			$(".menuArea .food_list .item .name").attr("class", "nameSmall");
    	                			this.menuFontClass = "nameSmall";
    	                		}else{ // 두 라인을 넘는게 없다면 원래 폰트로 바꾼다. (24px)
    	                			this.menuFontClass = "name";
    	                		}
    						}
    						
                        	// if(!util.isEmpty(this.prodAllList)) {
                        	// 	for(i=0; i < this.prodAllList.length; i++) {
                        	// 		//상단 카테고리 클릭시 active된 css제거후 선택된 상품 active 클래스 추가
                        	// 		$("#index"+this.prodAllList[i].PROD_CD).removeClass("active");
                        			
                        	// 		for(var x=0; x < this.orderList.length; x++){ // 선택된 상품개수만큼 루프
                        	// 			if(this.orderList[x].PROD_CD == this.prodAllList[i].PROD_CD){
                        	// 				$("#index"+this.prodAllList[i].PROD_CD).addClass("active");
                        	// 			}
                        	// 		}
                        	// 	}
                        	// }

							if(!util.isEmpty(gProdAllList)) {
                        		for(i=0; i < gProdAllList.length; i++) {
                        			//상단 카테고리 클릭시 active된 css제거후 선택된 상품 active 클래스 추가
                        			$("#index"+gProdAllList[i].PROD_CD).removeClass("active");
                        			
                        			for(var x=0; x < this.orderList.length; x++){ // 선택된 상품개수만큼 루프
                        				if(this.orderList[x].PROD_CD == gProdAllList[i].PROD_CD){
                        					$("#index"+gProdAllList[i].PROD_CD).addClass("active");
                        				}
                        			}
                        		}
                        	}
                        	
    						this.menuFontSmallFlag="N"
                        } ,
                        getOrderNo : function() {
                        	var posOrderNo = "";
                        	var posBillNo = "";
                        	//orderNo 채번 및 진동벨 호출

                        	util.logInfo("*****       orderPayInfoReg gsOrderNo Start ");

                        	if(gsOrderNoAspYn == "0" && mainPosNo != gPosNo  && util.GetEnvXmlShopENV(528) == 0 && gMainIp != "localhost") { // asp채번으로 설정(환경설정)되어 있고, 연동형이라면 asp에서 orderNo를 채번한다.
                				util.logInfo("*****orderPayInfoReg gsOrderNo SET ===>> " + gsOrderNo);
                				//posOrderNo=gsOrderNo; // 대기화면에서 미리 asp에서 채번해 놓은 gsOrderNo를 담는다.
                				var posOrderNoResult;
                				
                				if(!!gsOrderNo){// 채번해서 담고있는 변수가 0이 아니고 빈값이 아닐 때 채번하지 않는다. 이미 채번이 되어있는 상태이기 때문에
                        			util.logInfo("*****orderPayInfoReg gsOrderNo already exist *****");
                        			posOrderNo = gsOrderNo;
                        		} else {
                        			posOrderNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectPosOrderNo, [ gShopCd, saleDate, gPosNo]).Data ;
                        			posOrderNo = posOrderNoResult[0].MAX_ORDER_NO;
                        		}
                				
            					posBillNo = localStorage.getItem("gPosBillNo");
            					var sslTrhdrBillNoResult;
            					
            					util.logInfo("### posBillNo 11 >>> " + posBillNo);
            					
            					//로컬스토리지에 주문번호가 없는 경우
            					if(util.isEmpty(posBillNo)){
            						util.logInfo("### posBillNo is null, undefined");
            						sslTrhdrBillNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectBillNo, [gShopCd, saleDate, gPosNo]).Data;
                					posBillNo = sslTrhdrBillNoResult[0].BILL_NO;
                					util.logInfo("### posBillNo 22 >>> " + posBillNo);
            					}
            					
            					//getBillNo
            					sslTrhdrBillNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectBillNo, [gShopCd, saleDate, gPosNo]).Data;
            					var posBillNo2 = sslTrhdrBillNoResult[0].BILL_NO;
            					
            					util.logInfo("### posBillNo2 >>> " + posBillNo2);
            					
        						//결체취소시 증가된 영수증번호가 로컬스토리지 영수증 번호가 맞지 않는 경우(db에 저장된 영수증 맥스값이 큰경우)
        						if(Number(posBillNo2) > Number(posBillNo)) {
            						posBillNo = posBillNo2;
            					}
            					
                			} else { // 기존로직 - 키오스크 자체에서 채번하는 방식.

                				//var cbBillNoVal = localStorage.getItem("gCbBillNoVal");
                				
                				//2020-11-30 최강일 차장님 요청
                				//기존 주문번호 채번(4자리)에서 -> 포스번호(1자리) + 채번번호(3자리)로 변경 
                				//ex)"1" + "001"
                				//포스번호 10번이상 주문번호 999이상은 향후 채번번호 변경하신다고함.
                				var posOrderNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectPosOrderNo, [ gShopCd, saleDate, gPosNo]).Data ;
                				posOrderNo = posOrderNoResult[0].MAX_ORDER_NO;

                				if(posOrderNo == "0001"){
                					
                					//POS_ODHDR_T에 ORDER_NO가 없으면 SSL_TRHDR_T 에서 max ORDER_NO 가져온다.
                					//둘다 없을경우 포스번호 + 001로 세팅
                					posOrderNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectSslOrderNo, [ gShopCd, saleDate, gPosNo]).Data;
                					posOrderNo = posOrderNoResult[0].MAX_ORDER_NO;
                					util.logInfo("### sslOrderNo >>> " + posOrderNo);
                					
                					var setBillNumber = util.GetEnvXmlShopENV("735");
                					//getBillNo
                					var sslTrhdrBillNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectBillNo, [gShopCd, saleDate, gPosNo]).Data;
                					posBillNo = sslTrhdrBillNoResult[0].BILL_NO;

                		            util.logInfo("### sslTrhdrBillNo >>> " + posBillNo + ", setBillNumber : " + setBillNumber);

                		            //영수증번호 임의 채번
                					if(posBillNo == "0001" && !util.isEmptyStr(setBillNumber) && setBillNumber > 0 ){
                						posBillNo = setBillNumber + "0";
                					}
                					
                					//첫주문이 이퀴니스 requestOrder가 중복된 경우에는 로컬 디비상 0001부터 시작하기 때문에
                					//계속해서 0001로 시작하는 주문정보를 보내기 때문에 로컬 스토리지에 저장된 주문,영수증 번호로 세팅해준다
                					var lsPosOrderNo = localStorage.getItem("gPosOrderNo");
                					if(lsPosOrderNo != null && lsPosOrderNo != undefined){
                    					var lsPosBillNo = localStorage.getItem("gPosBillNo");
                    					
                    					//결체취소시 증가된 영수증번호가 로컬스토리지 영수증 번호가 맞지 않는 경우(db에 저장된 영수증 맥스값이 큰경우)
                    					if(Number(posBillNo) < Number(lsPosBillNo)) {
                    						posBillNo = lsPosBillNo;
                    					}
                    					
                    					if(Number(posOrderNo) < Number(lsPosOrderNo)) {
                    						posOrderNo = lsPosOrderNo;
                    					}
                					}
                					
                				} else {
                					//localStorage.setItem("gCbBillNoVal", "S");
                					posOrderNo = localStorage.getItem("gPosOrderNo");
                					posBillNo = localStorage.getItem("gPosBillNo");
                					
                					util.logInfo("### posOrderNo11 >>> " + posOrderNo);
                    				util.logInfo("### posBillNo11 >>> " + posBillNo);
                    				
                					var posOrderNoResult;
                					var sslTrhdrBillNoResult;
                					
                					//로컬스토리지에 영수증번호와 주문번호가 없는 경우
                					if(util.isEmpty(posOrderNo)){
                						posOrderNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectPosOrderNo, [ gShopCd, saleDate, gPosNo]).Data ;
                        				posOrderNo = posOrderNoResult[0].MAX_ORDER_NO;
                    					util.logInfo("### posOrderNo >>> " + posOrderNo);
                					}
                					
                					if(util.isEmpty(posBillNo)){
                						sslTrhdrBillNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectBillNo, [gShopCd, saleDate, gPosNo]).Data;
                    					posBillNo = sslTrhdrBillNoResult[0].BILL_NO;
                    					util.logInfo("### posBillNo >>> " + posBillNo);
                					}
                					
                					//getBillNo
                					posOrderNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectPosOrderNo, [ gShopCd, saleDate, gPosNo]).Data ;
                    				var posOrderNo2 = posOrderNoResult[0].MAX_ORDER_NO;
                					sslTrhdrBillNoResult = gfn_SQLiteSQLProcess(sqlQuery.selectBillNo, [gShopCd, saleDate, gPosNo]).Data;
                					var posBillNo2 = sslTrhdrBillNoResult[0].BILL_NO;
                					
                					//결체취소시 증가된 영수증번호가 로컬스토리지 영수증 번호가 맞지 않는 경우(db에 저장된 영수증 맥스값이 큰경우)
                					if(Number(posBillNo2) > Number(posBillNo)) {
                						posBillNo = posBillNo2;
                					}
                					
                					if(Number(posOrderNo2) > Number(posOrderNo)) {
                						posOrderNo = posOrderNo2;
                					}
                				}
                				
                				util.logInfo("### posOrderNo22 >>> " + posOrderNo);
                				util.logInfo("### posBillNo22 >>> " + posBillNo);
                				
                				//주문번호 임의 채번
                				var setOrderNumber = util.GetEnvXmlShopENV("734");

                                if(setOrderNumber !== undefined && Number(setOrderNumber) > 0){
									// 주문번호 3자리인 경우 강제로 4자리 맞추기 위해 "0" 붙임
									// setOrderNumber === "10" --> 010 -> 0100 으로 맞춰줌 (주방프린터 누락 방지)  // 20240115 , WDH
									if(setOrderNumber === "10" )  
									{
										setOrderNumber = "0" + setOrderNumber ;
									}

                                    if(posOrderNo == '0001') {
                                        util.logInfo("### sslOrderNo >>> " + posOrderNo + ", setOrderNumber : " + setOrderNumber);
                                        if(!util.isEmptyStr(setOrderNumber) ){
                                            posOrderNo = setOrderNumber + "0";
                                        }
                                    } else {
                                    	setOrderNumber = setOrderNumber + "0";
                                    	if(Number(posOrderNo) < Number(setOrderNumber)) {
                                    		posOrderNo = setOrderNumber;
                                    	}
                                    }
                                }else{
                                    util.logInfo("#####@@@ sslOrderNo posOrderNo >>> " + gPosNo.substr(1) + ", posOrderNo.substr(1) : " + posOrderNo.substr(1));
                                    posOrderNo = gPosNo.substr(1) + posOrderNo.substr(1);
                                }
                                
                                var pagmsOption = gfn_SQLiteSQLProcess(sqlQuery.selectPagmsOption, [gShopCd, gPosNo]).Data;
                                util.logInfo("### pagmsOption >>> " + JSON.stringify(pagmsOption));
                                
                                if (!!pagmsOption && pagmsOption.length > 0) {
                                	if(pagmsOption[0].PAG_TYPE_FG != "03" && pagmsOption[0].PAG_TYPE_FG != "51") {
                                		//진동벨 리텍 디스펜서타워형이 아닌경우 먼저 진동벨 호출
                                		util.logInfo("### go to getVibBellOption ");
                                		util.getVibBellOption(posOrderNo, "B");
                                	} 
                                }
                                
                			}

                			util.logInfo("### sslOrderNo >>> " + posOrderNo);
                			
                        	orderInfo.posOrderNo = posOrderNo;
                        	orderInfo.posBillNo = posBillNo;
                        	
                        	//커반주문번호 중복이슈(로봇에서 음료중복으로 인식)로 인해 결제버튼 클릭할 때 주문번호 영수증번호 증가하는 로직으로 변경
                        	localStorage.setItem("gPosOrderNo", String(Number(posOrderNo)+1).padding(4, "0"));
        					localStorage.setItem("gPosBillNo", String(Number(posBillNo)+1).padding(4, "0"));
                        	
                        	util.logInfo("### orderInfo.posOrderNo >>> " + orderInfo.posOrderNo);
                        	util.logInfo("### orderInfo.posBillNo >>> " + orderInfo.posBillNo);
                        },
                        makeTopCategoryList : function(topList) {
                        	//상단 카테고리가 2줄일때 12 / 34 / 56 이런식으로 세트형태로 상단 메뉴를 그려주기 때문에
                        	//상단 카테고리 리스트를 가져와서 두개씩 짝을 가지도록 리스트 데이터를 가공해준다
                        	if(topList == undefined){
                        		return;
                        	}
                        	
                        	var topRealList = []; 
                        	
                        	if(!gsTuClsAll || gsTuClsAll != "0"){ //ALL메뉴있는경우
                        		tmpData = util.clone(topList[0]);
                        		tmpData.TU_CLS_NM = "ALL";
                        		tmpData.TU_CLS_NM_EN = "ALL";
                        		tmpData.TU_CLS_CD = undefined;
                        		topList.unshift(tmpData);
                    		}
                        	
                        	var topListLength = topList.length;
                        	//var topTempListLength;
                        	var topRealListLength;
                        	topRealListLength = Math.ceil(topListLength / 2);
                        	
                        	var j=0;
                        	var x=4;

                        	if(topRealListLength > 4){
                        		// 8개이상일때
                        		// 1 3 5 7 9
                        		// 2 4 6 8 10
	                        	for(var i=0; i < topRealListLength; i++){
	                        		var topTempList = [];
	                        		topTempList.push(topList[j++]);
	                        		topTempList.push(topList[j++]);
	                        		topRealList.push(topTempList);
	                        	}
                        	} else {
                        		// 8개이하일때
                        		// 1 2 3 4 
                            	// 5 6 7 8
                        		for(var i=0; i < 4; i++){
                        			var topTempList = [];
                        			topTempList.push(topList[j++]);
                            		topTempList.push(topList[x++]);
                            		topRealList.push(topTempList);
                            	}
                        	}
                        	
                        	// 1 2 3 4 9  11
                        	// 5 6 7 8 10 12
//                        	var j=0;
//                        	var x=4;
//                        	
//                        	if(topRealListLength > 3){
//                        		for(var i=0; i < topRealListLength; i++){
//                            		if(i < 4){
//                            			var topTempList = [];
//                            			topTempList.push(topList[j++]);
//                                		topTempList.push(topList[x++]);
//                            		} else {
//                            			var topTempList = [];
//                            			topTempList.push(topList[x++]);
//                            			topTempList.push(topList[x++]);
//                            		}
//                            		topRealList.push(topTempList);
//                            	}
//                        	} else {
//                        		//상단 카테고리 리스트가 7개 이하일때는 강제적으로 for문을 4번 돌려준다.
//                        		for(var i=0; i < 4; i++){
//                        			var topTempList = [];
//                        			topTempList.push(topList[j++]);
//                            		topTempList.push(topList[x++]);
//                            		topRealList.push(topTempList);
//                            	}
//                        	}
                        	
                        	return topRealList;
                        }, 
                        categoryClickClass : function(index1, index2) {
                        	//console.log("######## index1 : " + index1 + ", ######## index2 : " + index2);
                        	if(index1 == 0 && index2 == 0) return true;
                        	else return false;
                        },
                        fnCouponChoicePopupBtn : function() {
                        	var messageObj = util.languageObjReturn(langCode,  'selectCouponPay');
                        	//향후 버튼명 확정후 변경
                        	var button1Name = "이퀴니스서버";
            				var button2Name = "배달 쿠폰";
            				var couponProdExs = "Y";
            				
            				//배탈쿠폰 비밀번호 입력하기전 선택된 상품이 없는경우 팝업창에서 버튼 비활성화
            				if ( this.orderList.length == 0 ) {
            					couponProdExs = "N";
            				}
            		        var dataObj = {"button1Show" : true, "button1Name" : button1Name, "button2Show" : true, "button2Name" : button2Name, message: messageObj, "button1Func": this.fnGoCouponBarcode, "button2Func": this.fnCouponPwdPopupBtn, "couponProdExs" : couponProdExs};
            		        
            		        //경고메세지 팝업
            		        eventBus.$emit('couponChoicePopup', dataObj);
                        },
                        fnCouponPwdPopupBtn : function() {
                        	util.logInfo("______________ (상품결제)배달쿠폰 버튼 선택 _______________" )
                        	orderInfo = {};
                        	orderInfo.POS_ODHDR_T = this.POS_ODHDR_T;
                        	orderInfo.POS_ODDTL_T = this.orderList ;
                        	orderInfo.POS_ODHDR_T.KITCHEN_MEMO		= this.KITCHEN_MEMO ;  // - KITCHEN_MEMO(string)   : 수령방법( takeout | eat )

                        	/**********************************************************
                        	 * 사이드 메뉴에 따라 달리 금액계산
                        	 * SALE_AMT
                        	 * DCM_SALE_AMT
                        	 * VAT_AMT
                        	 * 과세대상금액
                        	 * 비과세대상금액
                        	 **********************************************************/
                        	let TAX_SALE_AMT = 0 , NON_TAX_SALE_AMT = 0;
                        	let SDS_ORG_DTL_NO_CNT = 0;//side 의 그룹번호 지정.

                        	let cornerObj = {};

                        	let totalDcAmt = 0;
                        
                        	orderInfo.POS_ODDTL_T.forEach(e => {
                        		if(!util.isEmpty(e)) {
                        			if ( e.SIDE_MENU_YN == 'Y') {
                        				e.VAT_AMT      = parseInt( e.사이드_포함_VAT_총_합계      );
                        				e.SALE_AMT     = parseInt( e.사이드포함_합계금액 ); //SALE_AMT     : 매출액
                        				e.DCM_SALE_AMT = parseInt( e.사이드포함_합계금액 ); //DCM_SALE_AMT : 실매출액
                        				
//                        			if(SHOP_INFO.VAT_CD == "0") {
//                        				e.SALE_AMT     = e.SALE_AMT - e.VAT_AMT; //SALE_AMT     : 매출액
//                            			e.DCM_SALE_AMT = e.DCM_SALE_AMT - e.VAT_AMT; //DCM_SALE_AMT : 실매출액
//                        			} 
                        				
                        				/**************** SIDE 가 있을 경우 SDS_ORG_DTL_NO 넣기 Start .***************************/
                        				let sl = e.사이드_LIST  ;
                        				e.SDS_ORG_DTL_NO =  ++ SDS_ORG_DTL_NO_CNT;//채번은 1번부터 한다.
                        				sl.forEach( x => {
                        					x.SDS_ORG_DTL_NO =  SDS_ORG_DTL_NO_CNT;
                        				});
                        				/**************** SIDE 가 있을 경우 SDS_ORG_DTL_NO 넣기 End   .***************************/
                        				
                        			} else {
                        				e.VAT_AMT      = parseInt( e.VAT      );
                        				e.VAT_AMT      = parseInt( e.VAT_총_합계      );
                        				e.SALE_AMT     = parseInt( e.합계금액 ); //SALE_AMT     : 매출액
                        				e.DCM_SALE_AMT = parseInt( e.합계금액 ); //DCM_SALE_AMT : 실매출액
                        				
//                        			if(SHOP_INFO.VAT_CD == "0") {
//                        				e.SALE_AMT     = e.SALE_AMT - e.VAT_AMT; //SALE_AMT     : 매출액
//                            			e.DCM_SALE_AMT = e.DCM_SALE_AMT - e.VAT_AMT; //DCM_SALE_AMT : 실매출액
//                        			} 
                        			}
                        			
                        			var togoChargeTemp = 0;
                        			
                        			//포장할인 상품을 결제할때 과세대상금액에서 할인금액을 빼고 계산해준다
                        			//먹고가기 상품이 아니면서 핧인금액이 있는경우 결제상품별로 할인금액을 계산
                        			if(gvEatTakeOutVal == "0" || gvEatTakeOutVal == "1" || gvEatTakeOutVal == "2"){
                        				if(gOrderType == "takeout"){
                        					if(e.TOGO_CHARGE !== undefined && e.TOGO_PROD_YN !== undefined) {
                        						if(e.TOGO_PROD_YN != "N" && e.TOGO_CHARGE < 0){
                        							togoChargeTemp = Math.abs(e.TOGO_CHARGE) * e.ORDER_QTY;
                        							e.DC_AMT_PACK = togoChargeTemp;
                        							e.DC_AMT = e.DC_AMT_PACK;
                        							
//                        							if(SHOP_INFO.VAT_CD == "1") {
//                        								e.DCM_SALE_AMT = e.DCM_SALE_AMT - e.DC_AMT_PACK;
//                        							}
                        							
                        							totalDcAmt += togoChargeTemp;
                        						}
                        					} 
                        				}
                        			}
                        			
                        			if( e.TAX_YN == 'Y')  {
                        				TAX_SALE_AMT += e.SALE_AMT - e.VAT_AMT;
                        				if(SHOP_INFO.VAT_CD == "0") {
                        					//TAX_SALE_AMT += e.SALE_AMT - togoChargeTemp;
                        					this.calcByCornerData ( cornerObj , e      , e.SALE_AMT, e.VAT_AMT , e.SALE_AMT - e.VAT_AMT    , 0 );
                        				} else {
                        					//TAX_SALE_AMT += e.SALE_AMT - e.VAT_AMT - togoChargeTemp;
                        					this.calcByCornerData ( cornerObj , e      , e.SALE_AMT, e.VAT_AMT , e.SALE_AMT - e.VAT_AMT   , 0 );
                        				}
                        				
                        			} else {
                        				NON_TAX_SALE_AMT += e.SALE_AMT;
                        				this.calcByCornerData ( cornerObj , e      , e.SALE_AMT , e.VAT_AMT , 0 , e.SALE_AMT );
                        			}
                        			
                        			if(SHOP_INFO.VAT_CD == "0") {
                        				e.SALE_AMT     = e.SALE_AMT - e.VAT_AMT; //SALE_AMT     : 매출액
                        				e.DCM_SALE_AMT = e.DCM_SALE_AMT - e.VAT_AMT; //DCM_SALE_AMT : 실매출액
                        				e.NORMAL_UPRC = e.판매단가 - e.VAT;
                        				e.SALE_UPRC = e.NORMAL_UPRC;
                        				//TAX_SALE_AMT += togoChargeTemp;
                        			} else {
                        				e.NORMAL_UPRC  = e.판매단가;
                        			}
                        			
                        		}
                        	});

                        	orderInfo.POS_ODHDR_T.TAX_SALE_AMT = TAX_SALE_AMT;
                        	orderInfo.POS_ODHDR_T.VAT_SALE_AMT = TAX_SALE_AMT;
                        	orderInfo.POS_ODHDR_T.NON_TAX_SALE_AMT = NON_TAX_SALE_AMT;
                        	orderInfo.POS_ODHDR_T.NO_VAT_SALE_AMT  = NON_TAX_SALE_AMT;
                        	orderInfo.POS_ODHDR_T.NO_TAX_SALE_AMT  = TAX_SALE_AMT + NON_TAX_SALE_AMT;
                        	
                        	//총 포장할인 금액
                    		orderInfo.POS_ODHDR_T.DC_PACK_AMT = totalDcAmt;
                    		//총 할인금액 금액(제휴할인등 중복할인이 발생할 수 있음)
                    		//orderInfo.POS_ODHDR_T.TOT_DC_AMT = totalDcAmt;
                    		orderInfo.POS_ODHDR_T.TOT_DC_AMT = totalDcAmt + parseInt(orderInfo.POS_ODHDR_T.TOT_SALE_AMT);
                    		
                    		/** 사업자 과세 구분 0 : 별도, 1 : 포함. **/
                    		if(SHOP_INFO.VAT_CD == "0") {
                    			orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.NO_TOT_SALE_AMT;
                    		} else {
                    			//실매출금액 = 총 매출액 - 할인금액
                    			orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.TOT_SALE_AMT;
                    		}
                    		
                        	if ( util.isEmpty( this.POS_ODHDR_T )) {
                        		return;
                        	}

                        	orderInfo.CORNER_LIST = [];
                        	for(k in cornerObj) {
                        		if ( k.indexOf("_DATA") == -1 )
                        			orderInfo.CORNER_LIST.push(  cornerObj[k + '_DATA']);
                        	}
                        	orderInfo.CORNER_OBJ = cornerObj;
                        	
                        	//할인금액이 결제금액보다 큰 경우에 결제X
                        	if ( orderInfo.POS_ODHDR_T.DCM_SALE_AMT <= 0) {
                        		var obj = { message : "", messageType : "alert" };
                        		var msg = util.languageObjReturn(langCode,  'cantPayLess');
                        		obj.message = msg;		 
                        		util.logInfo( "cantPayLess msg : " + msg);
								this.$root.$emit( "notiMessage" ,   obj  );
								$('#noti_message').html("<p>"+obj.message+"</p>");
                        		return;
                        	}
                        	
                        	
                        	//orderNo 채번
                        	this.getOrderNo();
                        	
                        	util.logDebug(orderInfo);
                        	
                        	if(this.couponBarcode != "") {
                        		orderInfo.couponBarcode = this.couponBarcode;
                        		orderInfo.couponPayType = this.couponPayType;
                        	} else {
                        		orderInfo.couponPayType = this.couponPayType;
                        	}
                        	
                        	if(this.couponPayType == "D") {
                        		if(this.vsCouponVal == "5") {
                        			if(orderInfo.POS_ODHDR_T.TOT_SALE_AMT == orderInfo.POS_ODHDR_T.TOT_DC_AMT) {
                        				orderInfo.POS_ODHDR_T.DCM_SALE_AMT = orderInfo.POS_ODHDR_T.TOT_SALE_AMT - orderInfo.POS_ODHDR_T.TOT_DC_AMT;
                        				orderInfo.POS_ODHDR_T.NO_TAX_SALE_AMT = "0";
                        				orderInfo.POS_ODHDR_T.NO_TOT_SALE_AMT = "0";
                        				orderInfo.POS_ODHDR_T.TAX_SALE_AMT = "0";
                        				orderInfo.POS_ODHDR_T.VAT_SALE_AMT = "0";
                        				orderInfo.POS_ODHDR_T.VAT_AMT = "0";
                        			}
                            	}
                        		this.$router.push({ path : '/couponPwd' });
                        	} else {
                        		//상품권은 바로 결제로
                        		//paymentChoiceView.creditApprRequest();
                        		router.push({path: '/paymentChoiceView'});
                        	}
                        }
                        , 
                        clickHome : function() {
                        	if(gsSpecialShopFlag == "5" && gWaitingPageVal == "1") {
                            	// 기초관리 -> 설치자용 -> 매장환경설정 -> 포스환경 환경설정 번호 : 903 [대기화면제거]
                        		util.logInfo("*****order.menu.list.js menu inputPwdPopupShow Open*****");
                        		//더블클릭시 팝업창 보여줌
                            	var paramObj = {
                          			  title : "권한 확인"
                          			, openType : "inspection"
                          			, url : "admin"
                          			, totalAmt : ""
                            	};
                                this.$root.$emit('inputPwdPopupOpen', paramObj);
                            } else {
                            	this.$router.push({ path: '/start' });
                            }
                        }
                        , 
                        touchAudio : function() {
                        }
                        , fnGoCouponBarcode : function() {
                        	util.logInfo("______________ (상품결제)이퀴니스 바코드입력 버튼 선택 _______________" )
                        	this.$router.push({ path : '/couponBarcode' });
                        }
                        , addCouponProd : function(obj) {
                        	this.orderList = [];
                        	//승인받은 이니퀴스 쿠폰 상품리스트를 오더앱 상품코드와 비교하여 오더앱에서 주문항목에 추가해줘야한다.
                        	//this.prodAllList = orderMenuService.getProductData(null , langCode , vatCd);
							gProdAllList = orderMenuService.getProductData(null , langCode , vatCd);
                    		for(var i=0; i < obj.length; i++) {
                    			var couponProdList = [];
                    			//filter하게되면 카테고리별로 같은 상품이 중복으로 존재
                    			//couponProdList = this.prodAllList.filter(p => p.PROD_CD == obj[i].product_id );
								couponProdList = gProdAllList.filter(p => p.PROD_CD == obj[i].product_id );
                    			if(couponProdList.length > 0){
                    				if(couponProdList[0].KIOSK_PROD_STATUS != "4"){
                    					// 수량별로 항목추가 obj.EA : 상품수량
                    					if(obj[i].EA > 1) {
                    						for(var j=0; j < obj[i].EA; j++){
                    							this.clickProdRow(couponProdList[0]);
                    						}
                    					} else {
                    						this.clickProdRow(couponProdList[0]);
                    					}
                    				} else {
                    					//쿠폰상품중에 품절된 상품이 있는경우
                    					var obj = { message : util.languageObjReturn(langCode, 'itemOutOfStock'), messageType : "alert" };
                            			this.$root.$emit("notiMessage" , obj );
                            			$('#noti_message').html("<p>"+obj.message+"</p>");
                            			return;
                    				}
                    			} else {
                    				//쿠폰상품중에 품절된 상품이 있는경우
                					var obj = { message : util.languageObjReturn(langCode, 'itemOutOfStock2'), messageType : "alert" };
                        			this.$root.$emit("notiMessage" , obj );
                        			$('#noti_message').html("<p>"+obj.message+"</p>");
                        			return;
                    			}
                    		}
                    		
                    		this.fnCouponPwdPopupBtn();
                        }
                        ,
                        fnChgProdStatus : function(chgType) {
                        	//상품상태 변경 
                        	this.orderList;
                        	var kProdStatus = "";
                        	var kProdStatusList = [];
                        	
                        	//sold out or nomal
                        	if(chgType == "S") kProdStatus = "4"; 
        					else kProdStatus = "1"; 
        							
                        	for(var i=0; i < this.orderList.length; i++){
                        		var prodStatusAspResult;
                        		var localDate = moment().format("YYYYMMDDHHmmss");
        						var indexNo = gShopCd+localDate;
        						
        						this.orderList[i].KIOSK_PROD_STATUS = kProdStatus;
        						this.orderList[i].SALE_UPRC = this.orderList[i].SALE_UPRC_ORG;
        						
        						util.logInfo("fnChgProdStatus this.orderList["+i+"].PRT_NO : " +  this.orderList[i].PRT_NO);
        						
        						var printNos = [];
        						var printNoStr = this.orderList[i].PRT_NO;
        						
        						util.logInfo("fnChgProdStatus printNoStr : " +  printNoStr);
        						util.logInfo("fnChgProdStatus printNoStr : " +  typeof printNoStr);
        						if(printNoStr !== undefined && printNoStr !== null) {
        							if(printNoStr != "" ) {
        								printNos = printNoStr.split(",");
        							}
        						}
        						
        						//상품상태 건별로 asp전송
        						//prodStatusAspResult = aspData.productStatusChange("PS150", indexNo, this.orderList[i]);
        						prodStatusAspResult = aspData.productModifyRequest("PS150", indexNo, this.orderList[i], printNos);
        						util.logInfo("receiveAspData prodStatusAspResult : " +  JSON.stringify(prodStatusAspResult));

        						var txjmFd = prodStatusAspResult["TSP-NVP"]["TXJM-FD"];

        						// 상품가격 정보 수정 PS150 Response 정상 및 에러 처리
        						if(txjmFd["_RETCD"] == "0000") {
        							//asp서버 전송 성공한 상품들만 모아서 처리
        							kProdStatusList.push(this.orderList[i].PROD_CD);
        						} else {
        							util.logInfo("aspERROR=====>> _RETCD>>> " + txjmFd["_RETCD"]);
        						}
                        	}
                        	
                        	//로컬DB 상품상태 업데이트 처리
                        	kProdStatusList = Array.from(new Set(kProdStatusList));
                			
                        	util.logInfo("kProdStatusList >>> " + kProdStatusList);
                			
                        	let dataObj = {};
                        	//ASP에 상품 정보 갱신 리스트가 없을 경우
                        	if(kProdStatusList.length < 1) {
                        		dataObj.button2Show = true;
    							dataObj.button2Func = this.goToMainPage
    							dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
                        		dataObj.message = util.languageObjReturn(langCode,  'failUpdateProd');
        						eventBus.$emit('alertPopupIndex', dataObj);
                        			
                				util.logInfo("상품상태 정보갱신 실패! >>> ");
                				return false;
                        	}
                        	
                			var kProdStatusListStr = "";
                			for(var i=0; i < kProdStatusList.length; i++){
                				if(i+1 < kProdStatusList.length) kProdStatusListStr += kProdStatusList[i] + "','"
                				else kProdStatusListStr += kProdStatusList[i];
                			}
                			
                			util.logInfo("kProdStatusListStr >>> " + kProdStatusListStr);
                			
                			var resultData = gfn_SQLiteSQLProcess(sqlQuery.kioskProdStatusUpdate_SQL.sprintf(kProdStatus, gShopCd, kProdStatusListStr), []);
                			var obj = { message : "", messageType : "alert" };

                			dataObj.button2Show = true;
							dataObj.button2Func = this.goToMainPage
							dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
							
                			if ( resultData!= null && resultData.ResultCode == "0" ) {
                    			//obj.message = util.languageObjReturn(langCode,  'successUpdateProd');
                    			//this.$root.$emit( "notiMessage" ,   obj  );
                        			
                				util.logInfo("상품상태 정보갱신 성공! >>> ");
                				//상품정보 갱신 성공후 메인으로 이동
                				//this.$router.push({ path: '/start' });
                				
        						dataObj.message = util.languageObjReturn(langCode,  'successUpdateProd');
        						eventBus.$emit('alertPopupIndex', dataObj);
                			} else {
        						dataObj.message = util.languageObjReturn(langCode,  'failUpdateProd');
        						eventBus.$emit('alertPopupIndex', dataObj);
                        			
                				util.logInfo("상품상태 정보갱신 실패! >>> ");
                				//this.$router.push({ path: '/start' });
                			}
                        	
                        }
                        ,
                        goToMainPage : function() {
                        	util.logInfo("### goToMainPage ###");
                        	this.$router.push({ path: '/start' });
                        }
                        ,
                        fnShowBarcodePop : function() {
                        	util.logInfo("### fnShowBarcodePop START ###");
                        	let dataObj2 = {};
                        	this.$root.$emit('openScanBarCodePopup', dataObj2);
                        }
                        , fnStartBarCodeReader : function() {
                        	util.logInfo('barcode scan start!!')
                			try {
                				if(typeof tizen === 'undefined' ) {
                					//this.fncBarCodeListner("281006020000000000857324");//윈도우는 테스트 카카오 페이 신용
                				} else {
                					b2bbarcode.startScanBarcode(this.fncBarCodeListner);
                				}

        					} catch (e) {
        						util.logError(e);
        					}
                		}
                        , fncBarCodeListner : function(msg) {
                			let strBarcode ;
                			if(typeof tizen === 'undefined' ) {
                				strBarcode = msg;
                			} else {
                				if ( msg.data !== 'NOT_DETECTED' ){// 입력됨.
                					strBarcode = msg.data;
                					orderMenuService.barcodeNumResult(strBarcode);
                				} else {
                					
                					retryCount++;
                					util.logInfo(`barcode 입력안됨 ${retryCount}`);
                					this.fnStartBarCodeReader();// 재시도 함.
//                					if( retryCount < 10 ) {
//                						util.logInfo(`Simple pay barcode empty, so retry  [${ retryCount}]`);
//        								this.fnStartBarCodeReader();// 재시도 함.
//        								return;
//        							}
//        							retryCount = 0;
//        							let dataObj = {
//        								  button1Show : true
//        								, button1Name : util.languageObjReturn(langCode, 'noticeCancel') // [ 취소 ]
//        								, button1Func : function(){ router.push({path : '/paymentChoiceView'}) }
//        								, button2Show : true
//        								, button2Name : util.languageObjReturn(langCode, 'retry') // [ 재시도 ]
//        								, button2Func : this.fnStartBarCodeReader
//        								, message     : util.languageObjReturn(langCode, 'barCodeEasyPayRetry') // [ 다시 결재를 시도하시겠습니까? ]
//        								, timeout     : 30 * 1000
//        								, timeoutFunc : function() { router.push({ path : '/start'}) }
//        							};
//        							eventBus.$emit('alertPopupIndex' , dataObj);

                					return;
                				}
                			}
        				}
                        , fnStopBarCodeReader : function() {
                			if(typeof tizen == "undefined" ) return;
                			try {
                				b2bbarcode.stopScanBarcode();
        					} catch (e) {
        						util.logError(e);
        					}
                		}
                    }

                , beforeUpdate : function(){
						util.logInfo('order menu beforeUpdate');
                    }
                , updated : function(){
                		//if(this.callCnt < 2) {
            			util.logInfo('order menu updated 1');
            			
        				this.applyCssStyle();
        				
        				this.menuFontChange();
        				
        				/***********************************************************
        				 * 2020.11.17 추가.
        				 * 상품분류 클릭여부, 클릭했을때는 최상단으로 보낸다.
        				 ***********************************************************/
        				if ( swpFoodFlag == true ) {
        					if(this.shopUntactType != "0") {
        						swiperFood.setTranslate(0);
        					}
        					this.prodOnceApplyCssStyle();
        					this.fncSwiperEventUpdate();
        					swpFoodFlag = false;
        					$('.food_list .item').removeClass('on'); //[추가] 2020-06-12
        				}
                    		
//                    		this.callCnt++;
//                		} else {
//                			util.logInfo('order menu updated 2');
//                			this.callCnt = 0;
//                			if (typeof(swiperFood) !== "undefined" ) {
//                            	swiperFood.destroy(true, true);
//                            	swiperFood = undefined;
//                            }
//                            
//                            if (typeof(swiperFood2) !== "undefined" ) {
//                            	swiperFood2.destroy(true, true);
//                            	swiperFood2 = undefined;
//                            }
//                			return;
//                		}
						
                    }
                , destroyed : function(){
					util.logInfo('order menu destroyed');
					swiperFood = undefined , swiperCategory = undefined ;//초기화 안하면 결제 페이지 갔다가 다시 왔을때 정상 작동하지 않는다.
                }
            };
		return tmplate;
	}
	
	// 쿠폰비밀번호 입력 팝업
    this.fnCouponPwdPopup = function(){
    	 let couponPayCnt = 0;
    	 var returnTemplate = { template: '#couponPwdPop'
             , created : function() {
            	 this.toUse   		 = util.languageObjReturn(langCode,  'toUse');
            	 this.passwordIn  	 = util.languageObjReturn(langCode,  'passwordIn');

            	 if(gvOrderOnly == "2"){
      		    	 this.deliveryCoupon = util.languageObjReturn(langCode,  'adminCoupon');
      		     } else {
      		    	 this.deliveryCoupon = util.languageObjReturn(langCode,  'deliveryCoupon');
      		     }
             }
         	, mounted : function() {
             	// util.log('addPoint mounted==' );
             	this.$root.$on('couponPwdPop' , obj => {
             		util.logInfo("on -> couponPwdPop 1111" + JSON.stringify(obj));
             		this.styleObject = { display : 'block' };
             	});
             	
             	couponPayCnt = 0;
             }
			,beforeDestroy () {
 					this.$root.$off('couponPwdPop' );
 					couponPayCnt = 0;
 			}
         	, data : function () {
         		return {
         			styleObject : { display : 'none' }
         			, empPwd	  : ""
         		}
         	}
            , methods : {
	            fnNumberBox : function(value){
	                if(value == "C"){
	                    this.empPwd = "";
	                }else if(value == "D"){
	                    this.empPwd = this.empPwd.substr(0, (this.empPwd.length-1));
	                }else {
	                    this.empPwd = this.empPwd + value;
	                }
                },
	            
                fnChkCouponPwd : function(event){
                	util.logInfo("### fnCouponPwdPopup fnChkCouponPwd couponPayCnt >>> " + couponPayCnt);
                	//util.fnTouchAudio(); // 터치할 때 소리 나도록 함수 호출.
            		//비밀번호로 쿠폰번호 조회
                	//일단은 오더앱 로그인한 직원의 비밀번호와 쿠폰의 비밀번호가 일치하게 작업
                	//향후 쿠폰서버와 연동후 쿠폰 비밀번호 체크
                	var obj = { message : "", messageType : "alert" };

                	if(this.empPwd === undefined || this.empPwd === "" || this.empPwd === null){
            			obj.message = util.languageObjReturn(langCode,  'passwordIn');
		    			this.makeMessageAlert(obj);
            			return false;
            		}

        			var empInfo = JSON.parse(sessionStorage.getItem("EMP_INFO"));
        			var encPwd = SHA256(this.empPwd);
        			//util.log("encPwd >>> " + encPwd);

        			var dateResult = gfn_SQLiteSQLProcess(sqlQuery.selectLoginCheck, [gShopCd, empInfo.EMP_NO, encPwd]);
        			util.logInfo('### fnCouponPwdPopup fnChkCouponPwd dateResult : ' + JSON.stringify(dateResult));
        			
        			if(typeof dateResult === 'undefined') {
        				obj.message = util.languageObjReturn(langCode,  'chkCouponPwd');
		    			this.makeMessageAlert(obj);
        				return;
        			}

        			if(dateResult.Data == '' || dateResult.Data == null){
        				obj.message = util.languageObjReturn(langCode,  'chkCouponPwd');
		    			this.makeMessageAlert(obj);
        				return;
        			}
        			
        			if(couponPayCnt < 1){
        				couponPayCnt++;
        				util.logInfo("### fnCouponPwdPopup fnChkCouponPwd fnPayCouponBtn START >>> " + couponPayCnt);
        				//쿠폰결제시작
        				orderMenuService.fnPayCouponBtn();
        			}
            	},
            	
            	makeMessageAlert(messageObj) {
	    			this.$root.$emit( "notiMessage" ,   messageObj  );
            	}
            	, fnGoBack : function(){
        			router.push({path: '/menu'}); 
        		}
            }
    	 };
    	 return returnTemplate;
    }
    
    // 쿠폰바코드 입력 화면
    this.fnCouponBarcodeInqry = function(){
    	let couponPayCnt = 0;
    	var returnTemplate = { template: '#couponBarcodeInqry'
    		, created : function() {
    			this.toUse   		 = util.languageObjReturn(langCode,  'toUse');
    			this.passwordIn  	 = util.languageObjReturn(langCode,  'passwordIn');
    			this.deliveryCoupon = util.languageObjReturn(langCode,  'deliveryCoupon');
    		}
    	, mounted : function() {
    		// util.log('addPoint mounted==' );
    		this.$root.$on('couponPwdPop' , obj => {
    			util.logInfo("on -> couponPwdPop 1111" + JSON.stringify(obj));
    			this.styleObject = { display : 'block' };
    		});
    		
    		couponPayCnt = 0;
    	}
    	,beforeDestroy () {
    		this.$root.$off('couponPwdPop' );
    		couponPayCnt = 0;
    	}
    	, data : function () {
    		return {
    			styleObject : { display : 'none' }
    			, empPwd	  : ""
    		}
    	}
    	, methods : {
    		fnNumberBox : function(value){
    			if(value == "C"){
    				this.empPwd = "";
    			}else if(value == "D"){
    				this.empPwd = this.empPwd.substr(0, (this.empPwd.length-1));
    			}else {
    				this.empPwd = this.empPwd + value;
    			}
    		},
    		
    		fnChkCouponBarcode : function(event){
    			util.logInfo("### fnChkCouponBarcode fnPayCouponBtn couponPayCnt >>> " + couponPayCnt);
    			util.fnTouchAudio(); // 터치할 때 소리 나도록 함수 호출.
    			//비밀번호로 쿠폰번호 조회
    			//일단은 오더앱 로그인한 직원의 비밀번호와 쿠폰의 비밀번호가 일치하게 작업
    			//향후 쿠폰서버와 연동후 쿠폰 비밀번호 체크
    			var obj = { message : "", messageType : "alert" };
    			
    			if(this.empPwd === undefined || this.empPwd === "" || this.empPwd === null){
    				obj.message = util.languageObjReturn(langCode,  'passwordIn');
    				this.makeMessageAlert(obj);
    				return false;
    			}
    			
    			var empInfo = JSON.parse(sessionStorage.getItem("EMP_INFO"));
    			var encPwd = SHA256(this.empPwd);
    			//util.log("encPwd >>> " + encPwd);
    			
    			var dateResult = gfn_SQLiteSQLProcess(sqlQuery.selectLoginCheck, [gShopCd, empInfo.EMP_NO, encPwd]);
    			util.logInfo('### fnChkCouponBarcode dateResult : ' + JSON.stringify(dateResult));
    			
    			if(typeof dateResult === 'undefined') {
    				obj.message = util.languageObjReturn(langCode,  'chkCouponPwd');
    				this.makeMessageAlert(obj);
    				return;
    			}
    			
    			if(dateResult.Data == '' || dateResult.Data == null){
    				obj.message = util.languageObjReturn(langCode,  'chkCouponPwd');
    				this.makeMessageAlert(obj);
    				return;
    			}
    			
    			if(couponPayCnt < 1){
    				couponPayCnt++;
    				util.logInfo("### fnChkCouponBarcode START >>> " + couponPayCnt);
    				//쿠폰결제시작
    				orderMenuService.fnPayCouponBtn();
    			}
    		},
    		
    		makeMessageAlert(messageObj) {
    			this.$root.$emit( "notiMessage" ,   messageObj  );
    		}
    		, fnGoBack : function(){
    			router.push({path: '/menu'}); 
    		}
    	}
    	};
    	return returnTemplate;
    }
    
    this.fnPayCouponBtn = function() {
    	util.logInfo("______________ (상품결제)쿠폰 결제 START _______________");
    	if(  BIZ_CLS_TYPE == '0' ){
    		//단독사업자일떄만 쿠폰결제여서 단독결제 세팅하기위해서 파라미터를 바코드로 넘겨준다
    		//빈값으로 넘기게되면 신용카드로 세팅함
    		let payInfo = paymentChoiceService.singleBizAppr('BARCODE');
     		payInfo.catId = orderInfo.CORNER_LIST[0].VAN_TERM_NO;
			paymentChoiceView.fnCouponApproveRequestExe(payInfo , "");
    	} else {
    		var obj = { message : "", messageType : "alert" };
    		var msg = util.languageObjReturn(langCode,  'cannotMultiple');
    		obj.message = msg;		 
    		util.logInfo( "msg : " + msg);
    		eventBus.$emit( "alertPopupIndex" ,   obj  );
			$('#noti_message').html("<p>"+obj.message+"</p>");
    		return;
    		//paymentChoiceService.multiBizAppr(0);
    	}
    	
    }
    
    // 쿠폰 바코드 입력 화면(커피에반하다. 이퀴닉스 서버)
    this.fnGetCouponBarcode = function(){
    	// Test 코드.
		// orderInfo.POS_ODHDR_T = {};
		// orderInfo.POS_ODHDR_T.TOT_SALE_AMT = 11000;
		let retryCount = 0;
		let isFirst = true;
        let returnTemplate = {
			template: '#couponBarcode'
			, data : function() {
				return {
					
				}
			}
			, created : function(){
				this.paymentAmount   = util.languageObjReturn(langCode , 'paymentAmount');
				this.toPaySimple     = util.languageObjReturn(langCode , 'toPaySimple');
				this.scanBarCode     = util.languageObjReturn(langCode , 'scanBarCode');
				this.selBarCode      = util.languageObjReturn(langCode , 'selBarCode');
				this.distanceBarcode = util.languageObjReturn(langCode , 'distanceBarcode');
			}
            ,mounted : function() {
            	waitingService.ResetLogOutTimer(); // 대기영상으로 돌아가는 시간 초기화.
        		try {
					b2bbarcode.stopScanBarcode();
				} catch (e) {
					util.logError('## error barcode camera 바코드 승인났는데 카메라 안꺼짐.');
					util.logError(e);
				}

	        	retryCount = 0;// 초기화
            	this.$root.$on('couponBarCodeInputResult' , obj => {
					util.logInfo("on -> couponBarCodeInputResult " , obj);
					if (util.byteLen(obj.appType.trTypeKey) == 0) {

			        	retryCount = 0;// 초기화
			        	if(util.isTizen() === false ) {
			        		setTimeout( this.fnStartBarCodeReader ,2000);
			        	} else {
			        		this.fnStartBarCodeReader();
						}
					} else {
						this.fnCouponRequestCall( obj.appType , obj.barCode);
					}
            	});

            	// 카메라에 바코드 또는 QR코드를 인식해 주세요. 음성추가.
            	var paramSrc = "./audio/28.mp3";
 			    // string으로 보내면 해당 src한건 수행, 배열로 보내면 배열만큼 연속적으로 음성안내 수행 (한글src만 보내면됨)
 			    util.fnAudioPlay(paramSrc); // 음성안내 공통함수 호출
 			    
 			    /******************************************
 			     * 최초 화면 진입전에 바코드 카메라가 구동되어 간편결제 화면이 렌더링 되지 않는 문제가 있다.
 			     * Delay time 을 주어서 일부 회피한다.
 			     ******************************************/
        		if ( isFirst == true ) {
        			if(util.isTizen() === false ) {
        				setTimeout( this.fnStartBarCodeReader ,2000);
        			} else {
        				setTimeout( ()=> {
        					this.fnStartBarCodeReader();
        				}, 500)
        			}
        			isFirst = false;
        		}
            }
        	,beforeDestroy : function () {
        		this.$root.$off('couponBarCodeInputResult' );
        		retryCount= 0 , isFirst = true;
        		this.fnStopBarCodeReader();// 카메라 중지 한후 돌아가야한다.
        	}
        	, updated : function() {

        	}
        	,methods : {
            	fn_barCode_Popup : function() {
                    util.logInfo("openbarCodePopup Start");
                	try {
                		b2bbarcode.stopScanBarcode();
    				} catch (e) {
    				}

                    var paramObj = {
                    		a : 1
                    	  , b : 2
                    };
                    this.$root.$emit('openCouponBarCodePopup', paramObj);
                }
        		, fnHistoryBack : function() {
        			this.fnStopBarCodeReader();// 카메라 중지 한후 돌아가야한다.
              	    this.$router.push({ path : '/start' });
        		}
        		, fnStartBarCodeReader : function() {
        			util.logInfo('barcode scan start!!')
        			try {
        				if(typeof tizen === 'undefined' ) {
        					//this.fncBarCodeListner("281006020000000000857324");//윈도우는 테스트 카카오 페이 신용
        				} else {
        					b2bbarcode.startScanBarcode(this.fncBarCodeListner);
        				}

					} catch (e) {
						console.error(e);
					}
        		}
        		, fncBarCodeListner : function(msg) {
        			let strBarcode ;
        			if(typeof tizen === 'undefined' ) {
        				strBarcode = msg;
        			} else {
        				if ( msg.data !== 'NOT_DETECTED' ){// 입력됨.
        					strBarcode = msg.data;
        				} else {
        					retryCount++;
        					console.log(`barcode 입력안됨 ${retryCount}`);
        					if( retryCount < 10 ) {
        						console.log(`Simple pay barcode empty, so retry  [${ retryCount}]`);
								this.fnStartBarCodeReader();// 재시도 함.
								return;
							}
							retryCount = 0;
							let dataObj = {
								  button1Show : true
								, button1Name : util.languageObjReturn(langCode, 'noticeCancel') // [ 취소 ]
								, button1Func : function(){
													router.push({path : '/menu'})
												}
								, button2Show : true
								, button2Name : util.languageObjReturn(langCode, 'retry') // [ 재시도 ]
								, button2Func : this.fnStartBarCodeReader
								, message     : util.languageObjReturn(langCode, 'barCodeEasyPayRetry') // [ 다시 결재를 시도하시겠습니까? ]
								, timeout     : 30 * 1000
								, timeoutFunc : function() {
												router.push({ path : '/start'})
											}
							};
							eventBus.$emit('alertPopupIndex' , dataObj);

        					return;
        				}
        			}
        			this.fnSetAppType(strBarcode);
				}
				, fnCouponRequestCall : function( appType , strBarcode ) {
					util.logInfo("fnCouponRequestCall card auth call : " + strBarcode);
					
					try {

	             		//let payInfo = paymentChoiceService.singleBizAppr('BARCODE');
	             		//payInfo.catId = orderInfo.CORNER_LIST[0].VAN_TERM_NO;
						//paymentChoiceView.fnCreditApproveRequest(payInfo , appType, strBarcode , this.fnStartBarCodeReader);

						//util.ajaxCallJson(param, url, isAsync, callback);
						
						var paramData = {
							"token" : kerbanToken,
							"device_id" : gShopCd + gPosNo,
							"barcode" : strBarcode,
						}
//						var paramData = {
//								"token" : kerbanToken,
//								"device_id" : "DEVICE_A99",
//								"barcode" : strBarcode,
//						}
						//쿠폰조회
						var kerbanFullUrl = kerbanUrl + "api/fiserv/v1/barcodecheck" ;
						
						util.ajaxCallJson(paramData, kerbanFullUrl, false, this.fnAjaxCallJsonCallback);
						
					} catch (error) {
						console.error(error);
					}
				}
        		// app type 설정.
        		, fnSetAppType : function(strBarcode){
        			let appType ="" , dataObj = {};
					try {
						util.beep(); // 바코드 인식되었다는 비프음 출력.
						waitingService.ResetLogOutTimer(); // 대기영상으로 돌아가는 시간 초기화.
						appType = { trTypeKey : "132" , trTypeVal :'0' };
						//appType = util.GetSimplePayTrType(strBarcode);
						// bjk 중계서버 여기서 분기할 부분 확인하면 될거 같음.
						this.fnCouponRequestCall( appType , strBarcode);
					} catch (e) {
						console.error(e);
						let ecd = e.errCode;
						if ( ecd.startsWith("0") ) {
							dataObj.button2Show = false;
							dataObj.button1Func = this.fnStartBarCodeReader
						}  else {
							dataObj.button2Show = false;
							dataObj.button1Func = this.fnStartBarCodeReader
						}
						dataObj.message = e.errMsg;
						eventBus.$emit('alertPopupIndex', dataObj);
					}
        		}
        		, fnStopBarCodeReader : function() {
        			if(typeof tizen == "undefined" ) return;
        			try {
        				b2bbarcode.stopScanBarcode();
					} catch (e) {
						console.error(e);
					}
        		}
        		, fnAjaxCallJsonCallback : function(result) {
					util.logInfo("***** fnAjaxCallJsonCallback START *****");
					if(result == "error"){
						util.logError("*****fnAjaxCallJsonCallback result ERROR*****");
						var messageObj = "바코드 조회 실패. [이퀴닉스 관리자 문의]";
						var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
				        var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj};
				        //경고메세지 팝업
				        eventBus.$emit('alertPopupIndex', dataObj); 
				        this.fnStartBarCodeReader();
					}else if(result == "timeout"){
						var messageObj = util.languageObjReturn(langCode,  'timeoutMsg_2') + " [이퀴닉스 관리자 문의]"; // "서버와의 통신이 원활하지 않습니다. 주문 요청에 실패했습니다.";
						var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
				        var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj};
				        //경고메세지 팝업
				        eventBus.$emit('alertPopupIndex', dataObj); 
				        this.fnStartBarCodeReader();
					}else{
						util.logInfo("*****fnAjaxCallJsonCallback result ==>> "+ JSON.stringify(result));
						if(result.code == "200"){
							util.logInfo("*****fnAjaxCallJsonCallback result.items ==>> "+ result.items);
							util.logInfo("*****fnAjaxCallJsonCallback result.items ==>> "+ result.items.length);
							
							if(result.items.length > 0) {
								this.$root.$emit('couponBarCodeItems', result);
							}
							
						} else {
							//var messageObj = util.languageObjReturn(langCode,  'timeoutMsg_2');
							var messageObj = result.msg + " [이퀴닉스 관리자 문의]";
							var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
					        var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj};
					        //경고메세지 팝업
					        eventBus.$emit('alertPopupIndex', dataObj); 
					        this.fnStartBarCodeReader();
						}
					}							
				}
            }
        };
        return returnTemplate;
    },

    // 바코드 팝업
    this.fnGetBarCode = function(){
        var returnTemplate = { template: '#couponBarCodePopup'
            , created : function() {
            	util.logInfo('barCodePopup created=='  );
            	this.barCodeInput    = util.languageObjReturn(langCode , 'barCodeInput');
            	this.barCodeEntry    = util.languageObjReturn(langCode , 'barCodeEntry');
            	this.barcodeInputComplete    = util.languageObjReturn(langCode , 'barcodeInputComplete');
            }
        	, mounted : function() {
        		util.logInfo('fnGetBarCode mounted==' );
        		waitingService.ResetLogOutTimer(); // 대기영상으로 돌아가는 시간 초기화.
            	this.$root.$on('openCouponBarCodePopup' , obj => {
            		util.logInfo("on -> openCouponBarCodePopup " + JSON.stringify( obj ) );
            		this.styleObject = { display : 'block' };
            	});
            }
            ,beforeDestroy () {
            	util.logInfo('fnGetBarCode 바코드 팝업 beforeDestory');
					this.$root.$off('openCouponBarCodePopup' );
			}
        	, data : function () {
        		return {
        			 codeNum : "" // "222222222222222222222"
        		   , styleObject : { display : 'none' }
        		}
        	}
            , methods : {
            	fn_close : function() {
            		this.styleObject = {display : 'none'};

					let paramObj ={
							  appType : ""
							, barCode : ""
					};
					this.$root.$emit('couponBarCodeInputResult', paramObj);
            	}
            	// 바코드 키패드
            	,fn_number_keypad : function (key) {
            		// console.clear();
            		this.codeNum = paymentChoiceService.number_keypad( key, this.codeNum);
				}
				, fn_barCode_select : function() {
					let appType ;
					try {
						//this.codeNum = "869180001797";
						//appType = util.GetSimplePayTrType(this.codeNum);
						appType = { trTypeKey : "132" , trTypeVal :'0' };
						let paramObj ={
							  appType : appType
							, barCode : this.codeNum
						};
						this.$root.$emit('couponBarCodeInputResult', paramObj);
						this.styleObject = { display : 'none' };
					} catch (e) {
						util.logError("fn_barCode_select. e => " + e);
						let ecd = e.errCode;
						let dataObj = {};
						if ( ecd.startsWith("0") ) {
							dataObj.button2Show = false;
							dataObj.button1Func = this.fnStartBarCodeReader
						}  else {
							dataObj.button2Show = false;
							dataObj.button1Func = this.fnStartBarCodeReader
						}
						dataObj.message = e.errMsg;
						eventBus.$emit('alertPopupIndex', dataObj);
					}
				}
            }
        };
        return returnTemplate;
    }
    ,
    
    // 스캔 바코드 팝업
    this.fnGetScanBarCode = function(){
        var returnTemplate = { template: '#scanBarCodePopup'
            , created : function() {
            	util.logInfo('scanBarCodePopup created=='  );
            	this.barCodeInput    = util.languageObjReturn(langCode , 'barCodeInput');
            	this.barCodeEntry    = util.languageObjReturn(langCode , 'barCodeEntry');
            	this.barcodeInputComplete    = util.languageObjReturn(langCode , 'barcodeInputComplete');
            }
        	, mounted : function() {
        		util.logInfo('fnGetScanBarCode mounted==' );
        		
            	this.$root.$on('openScanBarCodePopup' , obj => {
            		util.logInfo("on -> openScanBarCodePopup " + JSON.stringify( obj ) );
            		this.codeNum = "";
            		this.styleObject = { display : 'block' };
            	});
            }
            ,beforeDestroy () {
            	util.logInfo('fnGetScanBarCode 바코드 팝업 beforeDestory');
            	this.$root.$off('openScanBarCodePopup' );
			}
        	, data : function () {
        		return {
        			 codeNum : "" // "222222222222222222222"
        		   , styleObject : { display : 'none' }
        		}
        	}
            , methods : {
            	fn_close : function() {
            		this.styleObject = {display : 'none'};
            	}
            	// 바코드 키패드
            	,fn_number_keypad : function (key) {
            		// console.clear();
            		this.codeNum = paymentChoiceService.number_keypad( key, this.codeNum);
				}
				, fn_barCode_select : function() {
					this.styleObject = { display : 'none' };
					orderMenuService.barcodeNumResult(this.codeNum);
				}
            }
        };
        return returnTemplate;
    }
    ,
    this.barcodeNumResult = function (value) {
    	var resultData = gfn_SQLiteSQLProcess("SELECT PROD_CD FROM SCD_BARCD_T WHERE BAR_CD = ?" , [value]);
		let rows;
		util.logInfo( "### 바코드 스캔값 : " + value);
		if ( resultData!= null && resultData.ResultCode == "0" ) {
			rows = resultData.Data;
			if ( rows == undefined || rows == null ||  rows.length == 0 ) {
				util.logInfo( "### 바코드 상품정보가 없습니다.");
				var messageObj = util.languageObjReturn(langCode, 'cantFindBarcodeProd');
				var button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
		        var dataObj = {"button2Show" : true, "button2Name" : button2Name, message: messageObj};
		        //경고메세지 팝업
		        $("#scanner").val();
		        eventBus.$emit('alertPopupIndex', dataObj);
		        
		        eventBus.$emit("barcodeScannerResultFail" , {} );
				return [];
			}
 	   	}
		
		$("#scanner").val();
    	let data = {
				 prodCd : rows[0].PROD_CD
       	};

    	eventBus.$emit("barcodeScannerResult" , data );
    }
    ,
    this.selCupComponent = function () {
		let template = {
				  template : "#selCupPop"
				, data : function() {
					let obj = {
					      styleObject : {display : 'none'}
						, message : ""
						, messageType : ""
					}
					obj.lang_title         = ""; // 타이틀
					obj.lang_choice        = util.languageObjReturn(langCode, 'choice'); // 선택
					obj.cupMsg1        = util.languageObjReturn(langCode, 'cupMsg1'); // '1회용 컵 보증금제도' 시행에 따라	
					obj.cupMsg2        = util.languageObjReturn(langCode, 'cupMsg2'); // 1회용 컵 사용시 300원의 보증금이
					obj.cupMsg3        = util.languageObjReturn(langCode, 'cupMsg3'); // 추가됩니다. 사용하실 컵을 선택해주세요.
					obj.burialCup      = util.languageObjReturn(langCode, 'burialCup'); // 매장컵
					obj.personalCup    = util.languageObjReturn(langCode, 'personalCup'); // 개인컵
					obj.disposableCup  = util.languageObjReturn(langCode, 'disposableCup'); // 1회용컵
					obj.cupVal         = ""; // 선택한 컵 종류
					obj.param          = {}; // 파라미터로 넘어온 값
					return obj;
				}

				, created : function () {
					util.logInfo('_____컵 선택 팝업 Create_____');
				}
				,
				 beforeDestroy () {
					this.$root.$off( 'selCupPop' );
				}
				, mounted : function () {
					util.logInfo('_____컵 선택 팝업 Mounted_____');
					if(!this.cupVal){
						this.cupVal = "burialCup";
					}
					this.$root.$on("selCupPop" , obj => {						
						this.styleObject = {display :'block'};
						util.logInfo('_____컵 선택 팝업으로 넘어온 파라미터 값 ==> ' + JSON.stringify(obj));
						this.param = obj;
					});
				}

				, methods : {
					fn_self_popup_close : function() {
						this.styleObject = {display : 'none'};
					}
					,
					fn_cupChoice : function () { // 선택 버튼 클릭 함수.
						if(!this.cupVal){
							util.logInfo('_____컵을 선택하셔야 합니다. 메시지 처리_____');
							let dataObj = {};
                			dataObj.button2Show = true;
                			dataObj.button2Name = util.languageObjReturn(langCode, 'noticeConfirm');// [ 확인 ]
                			dataObj.message = util.languageObjReturn(langCode,  'cupSelNoMsg'); // 컵을 선택하셔야 합니다.
                			eventBus.$emit('alertPopupIndex', dataObj);
							return false;
						}
						util.logInfo('_____선택한 컵 종류 == > ' + this.cupVal);
						this.param.CUP_TYPE = this.cupVal; // 선택한 컵을 row데이터안에 CUP_TYPE으로 담는다.
						util.logInfo('_____선택한 컵 종류 선택 후 팝업 닫기 및 메뉴선택 함수 호출_____ ');
						this.$root.$emit("cupPopResult" , this.param );
						this.styleObject = {display : 'none'};
					}
					,
					fn_cupSelect : function(val){ // 컵종류 선택할 때마다 해당 함수 호출
						if(val == "burialCup"){
							$("#btnBurialCup").addClass('on');
							$("#btnPersonalCup").removeClass('on');
							$("#btnDisposableCup").removeClass('on');
						}else if(val == "personalCup"){
							$("#btnBurialCup").removeClass('on');
							$("#btnPersonalCup").addClass('on');
							$("#btnDisposableCup").removeClass('on');
						}else if(val == "disposableCup"){
							$("#btnBurialCup").removeClass('on');
							$("#btnPersonalCup").removeClass('on');
							$("#btnDisposableCup").addClass('on');
						}else{
							$("#btnBurialCup").removeClass('on');
							$("#btnPersonalCup").removeClass('on');
							$("#btnDisposableCup").removeClass('on');
						}
						util.logInfo('_____선택하고 있는 컵 종류 == > ' + val);
						this.cupVal = val; // 변수값에 선택한 값을 담는다.
					}
				}

				, updated : function () {
					util.logInfo('_____컵 선택 팝업 update_____');
				}
				, beforeUpdate : function(){
		        }

		};///end let template
		return template;
	}
}